#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "proc_nodes.h"

char filename[255];
node_data data[TOTAL_NODES];
unsigned int no_nodes = 0;
unsigned int no_CHs = 0;
unsigned int no_CHs_no_tree = 0;
unsigned int no_in_cluster = 0;
unsigned int no_in_cluster_no_tree = 0;         //Nodes that are in a cluster but not in the tree
unsigned int no_no_cluster = 0;
unsigned char max_depth_node = 0;
unsigned char max_depth_CH = 0;
unsigned int max_CID = 0;
unsigned int no_bcast = 0;
unsigned int no_ack = 0;
float ave_cluster_size, std_cluster_size, ave_depth_node, ave_depth_CH;

int *node_depth;
int *CH_depth;


int main()
{
	load_data();
	process_data();
	print_results();
	return 0;
}

//Load node data from file
void load_data()
{
	FILE *fp;
	char str[100];
	unsigned int nid, cid, ch_nid, parent_ch_nid, no_child_nodes, no_bcasts, no_acks;
	unsigned char depth;
	
	fp = fopen(FILENAME, "r");
	if(fp == NULL)
	{
		perror("ERROR:");
		exit(1);
	}
	
	while(fgets(str, 100, fp) != NULL)
	{
		sscanf(str, "%d %d %d %d %d %d %d %d", &nid, &cid, &ch_nid, &parent_ch_nid, &depth, &no_child_nodes, &no_bcasts, &no_acks);
		data[no_nodes].NID = nid;
		data[no_nodes].CID = cid;
		data[no_nodes].CH_NID = ch_nid;
		data[no_nodes].parent_CH_NID = parent_ch_nid;
		data[no_nodes].depth = depth;
		data[no_nodes].no_children = no_child_nodes;
		data[no_nodes].no_bcasts = no_bcasts;
		data[no_nodes].no_ACKs = no_acks;
		no_nodes++;
	}

	fclose(fp);
}

//Process data in given order
void process_data()
{
	int i;

	for(i = 0; i < no_nodes; i++)
	{
		if(data[i].CID == 0)
			no_no_cluster++;
		else if(data[i].NID == data[i].CH_NID)
		{
			no_CHs++;	
			no_in_cluster++;

                       if(data[i].depth >= 254)           //if a CH but not in the cluster tree
                        {
                                no_CHs_no_tree++ ;
                                no_in_cluster_no_tree++;
                        }

			if((data[i].depth > max_depth_CH) && (data[i].depth < 254))
				max_depth_CH = data[i].depth;
			if(data[i].CID > max_CID)
				max_CID = data[i].CID;
		}
		else if(data[i].NID != 0)
		{
			no_in_cluster++;

			if(data[i].depth >= 254)           //In a cluster but not in the cluster tree
                                no_in_cluster_no_tree++ ;

			if((data[i].depth > max_depth_node) && (data[i].depth < 254))
				max_depth_node = data[i].depth;

		}
		no_bcast += data[i].no_bcasts;
		no_ack += data[i].no_ACKs;
	}

	cluster_size();
	node_depth_destri();
	CH_depth_destri();
}

//determine cluster size & STD of cluster size
void cluster_size()
{
	double total = 0; 
	unsigned int *ch_size, i;

	ch_size = (int*)calloc(max_CID, sizeof(int));
	for(i = 0; i < max_CID; i++)
		ch_size[i] = 0;

	for(i = 0; i < no_nodes; i++)
	{
		if(data[i].CID != 0)
			ch_size[(data[i].CID - 1)]++;
	}

	for(i = 0; i < max_CID; i++)
	{
		if(ch_size[i] != 0)
			total += ch_size[i];
	}

	ave_cluster_size = total / no_CHs;
	total = 0;

	for(i = 0; i < max_CID; i++)
	{
		if(ch_size[i] != 0)
			total += (ch_size[i] - ave_cluster_size) * (ch_size[i] - ave_cluster_size);
	}	
	std_cluster_size = sqrt((total / no_CHs));
	free(ch_size);
}

//Determine destribution of node depth
void node_depth_destri()
{
	int i;
	double total = 0;

	node_depth = (int*)calloc((max_depth_node + 1), sizeof(int));
	if(node_depth == NULL)
	{
		printf("Unable to acclocate memory......\n");
		exit(1);
	}

	for(i = 0; i < no_nodes; i++)
	{
		if((data[i].CID != 0) && (data[i].depth > 0) && (data[i].depth < 254))
			node_depth[data[i].depth]++;
	}
	node_depth[0] = 1;			//Add depth of root node

	for(i = 0; i <= max_depth_node; i++)
		total += node_depth[i] * i;

	ave_depth_node = total / no_in_cluster;
}

//Determine distribution of CHs
void CH_depth_destri()
{
	int i;
	double total = 0;

	CH_depth = (int*)calloc((max_depth_CH + 1), sizeof(int));
	if(node_depth == NULL)
	{
		printf("Unable to acclocate memory......\n");
		exit(1);
	}

	for(i = 0; i < no_nodes; i++)
	{
		if((data[i].CID != 0) && (data[i].CH_NID == data[i].NID) && (data[i].depth > 0) && (data[i].depth < 254))
			CH_depth[data[i].depth]++;
	}
	CH_depth[0] = 1;			//Add depth of root node

	for(i = 0; i <= max_depth_CH; i++)
		total += CH_depth[i] * i;
	
	ave_depth_CH = total / no_CHs;
}

//Print data to the console
void print_results()
{
	int i;
	printf("%d\t%d\t%d\t%d\t%d\t%d\t%f\t%f\t%d\t%d\t\t%f\t%d\t%f\t%d\t\t", no_nodes, no_CHs, no_CHs_no_tree, no_in_cluster, no_in_cluster_no_tree, no_no_cluster, ave_cluster_size, std_cluster_size, no_bcast, no_ack, ave_depth_node, max_depth_node, ave_depth_CH, max_depth_CH);
	
	for(i = 0 ; i <= max_depth_node; i++)
		printf("%d\t", node_depth[i]);
	for(i = (max_depth_node + 1) ; i < 32; i++)
		printf("0\t");
	printf("\t");

	for(i = 0 ; i <= max_depth_CH; i++)
		printf("%d\t", CH_depth[i]);
	for(i = (max_depth_CH + 1) ; i < 32; i++)
		printf("0\t");
	printf("\n");
	free(node_depth);
	free(CH_depth);
}
