#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "STD.h"

int main()
{
	printf("%f\t%f\t%f\n", calculate_mean(), calculate_variance(), calculate_STD());
	return 0;
}

double calculate_mean()
{
	double total = 0;
	double mean = -1;
	FILE *fp;
	int n = 0;
	char str[20];
	
        fp = fopen(IN_FILE, "r");
	if(fp == NULL)
	{
      		perror("ERROR:");
		exit(1);
	}
	while(fgets(str, 20, fp) != NULL)
	{
		total += atof(str);
		n++;
	}
	
        fclose(fp);
	
	if(n > 0)
	{
		mean = total / n;
		return mean;
	}
	else
	{
		printf("No inputs\n");
		return mean;
	}
}

double calculate_variance()
{
	double variance = -1;
	double mean ;
	double tmp_value = 0;
	FILE *fp;
	double total = 0;
	int n = 0;
	char str[20];

	mean = calculate_mean();
	if(mean < 0)
	{
		printf("Can't calculate variance. Wrong mean\n");
		return -1;
	}
        
	fp = fopen(IN_FILE, "r");
	if(fp == NULL)
	{
		perror("Error: ");
		exit(1);
	}
	
	while(fgets(str, 20, fp) != NULL)
	{
		tmp_value = atof(str);
		total += (tmp_value - mean) * (tmp_value - mean);
		n++;
	}
		
	if(n > 0)
	{
		variance = total / n;
		return variance;
	}
	else
	{
		printf("No inputs\n");
		return variance;
	}	
}

double calculate_STD()
{
	double std;

	std = calculate_variance();
	if (std < 0)
	{
		printf("Can't calculate STD. Wrong variance\n");
		return -1;
	}
	else
		return sqrt(std);
}
