#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#define MAXNODES 	200000
#define NONODES		1000
#define NODESX	 	400	
#define NODESY		500
#define NODEFILE	"input_nodes.txt"

int main()
{
	int count, NID, x, y, i, retvalue;
	int nodes[MAXNODES];
	FILE *fd;
	char msg[6];
	
	count = 0;	
	srand(time(NULL));                              //Set the seed for rand()
	
	for(i=0; i< MAXNODES; i++)
		nodes[i] = 0;
	
	while(1)					//Loop forever
	{
		x = rand() % NODESX;
		y = rand() % NODESY;						
		//Remove following lines if not need
		/*---------------------------------------------------*/
		if((x % 10) != 0)
			continue;
		if((y % 10) != 0)
			continue;
		/*---------------------------------------------------*/

		NID = y * NODESX + x + 1;   		// Set NIDs from left to right. Set nos from 1
		if(nodes[NID - 1] == 0)
		{
			nodes[NID - 1] = NID;	
			count++;
		}
		if(count == NONODES)			//Generate upto NONODES nodes
			break;
	}

	//NID = (180) * NODESX + (NODESX/2) + 1;	//If the middle node doesn't exist quit
	NID = (NODESY/2) * NODESX + (NODESX/2) + 1;	//If the middle node doesn't exist quit
	if(nodes[NID - 1] == 0)
		exit(0);
	
	fd = fopen(NODEFILE, "w");

	for(i=0; i<MAXNODES; i++)
	{
		if(nodes[i] != 0)
		{
			retvalue =  sprintf(msg, "%d\n", nodes[i]);
			fputs(msg, fd);
		}
	}
	fclose(fd);
	return 0;
}
