#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

#define MAXNODES 	1001*1001
#define NONODES		5000
#define NODESX	 	1001	
#define NODESY		1001
#define STARTX		500
#define STARTY		500
#define NODEFILE	"input_nodes.txt"
#define R		500
#define NONODES_G1      66
#define NONODES_G2      49
#define NONODES_G3      30
#define SIGMA           50


gsl_rng *r;
const gsl_rng_type *T;

/*-----------------------------------------------------------------------*
 * Initialize the gaussian random number generator                       *
 *-----------------------------------------------------------------------*/
void gaussian_rnd_init()
{
    unsigned long int seed;
  
    seed = time(NULL); 
    gsl_rng_env_setup();

    T=gsl_rng_default;

    r = gsl_rng_alloc(T);
    gsl_rng_set(r,seed); 
}

/*----------------------------------------------------------------------*
 * Remove the gaussian random number generator                          *
 *----------------------------------------------------------------------*/
void gaussian_rnd_remove()
{
    gsl_rng_free (r);
}


int main()
{
    int total_count, tmp_count, NID, x, y, tmp_x, tmp_y, i, retvalue, nodes2generate, tmp_NID;
    double rnd_x, rnd_y;
    int nodes[MAXNODES];
    FILE *fd;
    char msg[10];
    float length;

    total_count = 0;
    tmp_count = 0;
    srand(time(NULL));                      //Set the seed for rand()
    gaussian_rnd_init();                    //Initialize Gaussian random number generator

    for(i=0; i< MAXNODES; i++)              //Make the array 0
    	nodes[i] = 0;
    
    for(y = 50 ; y < NODESY;)
    {
        for(x = 50 ; x < NODESX;)
        {
            
            if(((x == 150) && (y == 150))  || ((x == 850) && (y == 150)) || ((x == 150) && (y == 850)) || ((x == 850) && (y == 850)))                    
                nodes2generate = NONODES_G3;
            else if(((x == 350) && (y == 50)) || ((x == 650) && (y == 50)) || ((x == 350) && (y == 950)) || ((x == 650) && (y == 950))
                    || ((x == 50) && (y == 350)) || ((x == 950) && (y == 350)) || ((x == 50) && (y == 650)) || ((x == 950) && (y == 650))
                    )
                nodes2generate = NONODES_G2;
            else
                nodes2generate = NONODES_G1;
                    
            length = sqrt((x - STARTX)*(x - STARTX) + (y - STARTY)*(y - STARTY));
            if(length > R)                  //skip if beyound the circle boundary
            {
                x += 100;
                continue;
            }
            tmp_count = 0;
            while(1)					//Loop forever
            {
                //generate node's relative X & Y
		rnd_x = gsl_ran_gaussian(r,SIGMA);
		rnd_y = gsl_ran_gaussian(r,SIGMA);					
                
                //Generate node's absolute
                tmp_x = (x + (int)rnd_x) % NODESX;
                tmp_y = (y + (int)rnd_y) % NODESY;
                
                length = sqrt((tmp_x - STARTX)*(tmp_x - STARTX) + (tmp_y - STARTY)*(tmp_y - STARTY));
                if(length <= R)                         //If within circle
                {
                    NID = tmp_y * NODESX + tmp_x + 1;   // Set NIDs from left to right. Set nos from 1
                    if(nodes[NID - 1] == 0)
                    {
                        nodes[NID - 1] = NID;	
                        tmp_count++;
                        total_count++;
                        
                        if(tmp_count == nodes2generate)	//Generate upto NONODES nodes
                        break;
                    }                   
                }
            }
            x += 100;
        }
        y += 100;    
    }

    NID = STARTY * NODESX + STARTX + 1;	//If the middle node doesn't exist quit
    if(nodes[NID - 1] == 0)
    {
        for(x = (STARTX - 8); x <= (STARTX + 8); x++)
        {
            for(y = (STARTY - 8); y <= (STARTY + 8); y++)
            {
                tmp_NID = y * NODESX + x + 1;	//If the middle node doesn't exist quit
                if(nodes[tmp_NID - 1] != 0)
                {
                    nodes[tmp_NID - 1] = 0;
                    nodes[NID - 1] = NID;
                }
            }
        }
        if(nodes[NID - 1] == 0)  
            exit(0);   
    }
    
    total_count=0;	
    fd = fopen(NODEFILE, "w");

    for(i=0; i<MAXNODES; i++)
    {
        if(nodes[i] != 0)
        {
            retvalue =  sprintf(msg, "%d\n", nodes[i]);
            fputs(msg, fd);
            total_count++;
        }
    }
    
    fclose(fd);
    gaussian_rnd_remove();
    
    return 0;
}


