﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Forms;
using System.Configuration;
using System.Drawing;
using System.Drawing.Imaging;

using System.IO;

namespace VSN
{
    public partial class VSN : Form
    {
        private int grid_X, grid_Y, nodes_X, nodes_Y, start_X, start_Y, no_Nodes;
        private float R;
        private string node_File;
        private Nodes[] nodeList;
        private int offset_x = 20;
        private int offset_y = 60;
        private int zFact = 4;

        public VSN()
        {
            InitializeComponent();
            this.Paint += new PaintEventHandler(generate);
        }

        private void VSN_Load(object sender, EventArgs e)
        {
            this.load_config_data();        //Load configuration data
        }

        private void configureToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Load the configuration data
            VSN_Config config_form = new VSN_Config();
            config_form.Visible = true;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void generateToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Invalidate();                //Generate the drawing
        }

        private RectangleF myRectangle(float x, float y, float width, float height)
        {
            return new RectangleF((x - (width / 2)), (y - (height / 2)), width, height);
        }

        private PointF[] Child_Points(float x, float y, float r)
        {
            float h, new_r;
            PointF[] my_hexa_points = new PointF[6];

            new_r = (r * this.zFact)/ this.grid_X;
            h = (float)((Math.Sqrt(3) * new_r ) / 2);
            my_hexa_points[0].X = x;
            my_hexa_points[0].Y = y - 2 * h;
            my_hexa_points[1].X = x + (float)Math.Sqrt(3) * h;
            my_hexa_points[1].Y = y - h;
            my_hexa_points[2].X = x + (float)Math.Sqrt(3) * h;
            my_hexa_points[2].Y = y + h;
            my_hexa_points[3].X = x;
            my_hexa_points[3].Y = y + 2 * h;
            my_hexa_points[4].X = x - (float)Math.Sqrt(3) * h;
            my_hexa_points[4].Y = y + h;
            my_hexa_points[5].X = x - (float)Math.Sqrt(3) * h;
            my_hexa_points[5].Y = y - h;

            return my_hexa_points;
        }

        private PointF[] Hexagonal_Coordinates(float x, float y, float r)
        {
            float h, new_r;
            PointF[] my_hexa_points = new PointF[6];

            new_r = (r * this.zFact)/this.grid_X;
            h = (float)((Math.Sqrt(3) * new_r ) / 2);
            my_hexa_points[0].X = x - (new_r/2);
            my_hexa_points[0].Y = y - h;
            my_hexa_points[1].X = x + (new_r/2);
            my_hexa_points[1].Y = y - h;
            my_hexa_points[2].X = x + new_r;
            my_hexa_points[2].Y = y ;
            my_hexa_points[3].X = x + (new_r/2);
            my_hexa_points[3].Y = y + h;
            my_hexa_points[4].X = x - (new_r/2);
            my_hexa_points[4].Y = y + h;
            my_hexa_points[5].X = x - new_r;
            my_hexa_points[5].Y = y;

            return my_hexa_points;

        }
        /*----------------------------------------------------------------------*
         * This function load configuration data from the VSN.exe.conf file    *
         *----------------------------------------------------------------------*/
        private void load_config_data()
        {
            this.grid_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Grid_X"));
            this.grid_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Grid_Y"));
            this.nodes_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes_X"));
            this.nodes_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes_Y"));
            this.start_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Start_X"));
            this.start_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Start_Y"));
            this.R = float.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("R"));
            this.node_File = System.Configuration.ConfigurationManager.AppSettings.Get("Node_file");
            this.no_Nodes = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes"));
        }

        /*----------------------------------------------------------------------*
         * This function load node data into the node array.                    *
         *----------------------------------------------------------------------*/
        private void loadData(int no_nodes, string node_file)
        {
            string data;
            string[] tmp_data = new string[11];
            
            this.nodeList = new Nodes[no_nodes];    //Generate the node array
            
            //Open file
            FileStream fs = new FileStream(node_file, FileMode.Open);
            //Use a stream reader
            StreamReader sReader = new StreamReader(fs, Encoding.ASCII);

            //For each node read data from the file
            for (int i = 0; i < no_nodes; i++)
            {
                data = sReader.ReadLine();
                tmp_data = data.Split(new Char[] { });  //Split data based on tabs
                               
                 if (int.Parse(tmp_data[1]) != 0)                 //If in a cluster
                 {
                    if (string.Compare(tmp_data[0], tmp_data[2]) == 0)    //If NID & CH_NID is same
                        //Set the node ID, cluster ID, parent CH NID, set as a CH
                        nodeList[i] = new Nodes(int.Parse(tmp_data[0]), int.Parse(tmp_data[1]), int.Parse(tmp_data[3]), true, true, int.Parse(tmp_data[4]), int.Parse(tmp_data[9]), int.Parse(tmp_data[10]));
                    else
                        //Set the node ID, cluster ID, no parent CH, set as a in cluster but not a CH
                        nodeList[i] = new Nodes(int.Parse(tmp_data[0]), int.Parse(tmp_data[1]), 0, false, true, int.Parse(tmp_data[4]), int.Parse(tmp_data[9]), int.Parse(tmp_data[10]));
                }
                 else
                     //Set the node ID, set as not a member of a cluster
                     nodeList[i] = new Nodes(int.Parse(tmp_data[0]), 0, 0, false, false, 0, 0, 0);
            }
            fs.Close();
        }

        protected void generate(object sender, PaintEventArgs e)
        {
            int x, y, x2, y2, c_x, c_y, c_x2, c_y2, color_id;
            float r;

            if (this.nodeList == null)          //Check whether data is not already loaded
                this.loadData(this.no_Nodes, node_File);   //Load node data from node file
            else
            {
                this.nodeList = null;           //If already loaded just diacard
                this.loadData(this.no_Nodes, node_File);   //Load node data from node file
            }

            Graphics g = e.Graphics;
            g.PageUnit = GraphicsUnit.Pixel;
            Rectangle border = new Rectangle(offset_x, offset_y, (nodes_X * zFact), (nodes_Y * zFact));
            Pen myPen = new Pen(Color.Black, 2 / g.DpiX);
            g.DrawRectangle(myPen, border);
            SolidBrush myBrush = new SolidBrush(Color.Black);
            Pen myPen2 = new Pen(Color.Black, 2 / g.DpiX);
            Pen myPen3 = new Pen(Color.Black, 1 / g.DpiX);

            for (int i = 0; i < this.no_Nodes; i++)
            {
                x = (this.nodeList[i].NID - 1) % this.nodes_X;
                y = (this.nodeList[i].NID - 1) / this.nodes_X;
                c_x = zFact * x + offset_x;
                c_y = zFact * y + offset_y;

                if (this.nodeList[i].inCluster == true)         //if the node is in a cluster
                {
                    if (this.nodeList[i].is_CH == true)
                    {
                        myBrush.Color = Color.Red;
                        myPen2.Color = Color.Red;
                    }
                    else
                    {
                        myBrush.Color = Color.Gray;
                        myPen2.Color = Color.Gray;
                    }

                    //if(this.nodeList[i].is_CH == true)
                    //    color_id = this.nodeList[i].Depth % 12;
                    //else
                    //    color_id = this.nodeList[i].CID % 12;

                    //switch (color_id)
                    //{
                    //    case 0:
                    //        myBrush.Color = Color.Black;
                    //        myPen2.Color = Color.Black;
                    //        break;
                    //    case 1:
                    //        myBrush.Color = Color.Red;
                    //        myPen2.Color = Color.Red;
                    //        break;
                    //    case 2:
                    //        myBrush.Color = Color.Blue;
                    //        myPen2.Color = Color.Blue;
                    //        break;
                    //    case 3:
                    //        myBrush.Color = Color.Brown;
                    //        myPen2.Color = Color.Brown;
                    //        break;
                    //    case 4:
                    //        myBrush.Color = Color.DarkBlue;
                    //        myPen2.Color = Color.DarkBlue;
                    //        break;
                    //    case 5:
                    //        myBrush.Color = Color.DarkGreen;
                    //        myPen2.Color = Color.DarkGreen;
                    //        break;
                    //    case 6:
                    //        myBrush.Color = Color.Green;
                    //        myPen2.Color = Color.Green;
                    //        break;
                    //    case 7:
                    //        myBrush.Color = Color.DarkOrange;
                    //        myPen2.Color = Color.DarkOrange;
                    //        break;
                    //    case 8:
                    //        myBrush.Color = Color.DeepPink;
                    //        myPen2.Color = Color.DeepPink;
                    //        break;
                    //    case 9:
                    //        myBrush.Color = Color.Yellow;
                    //        myPen2.Color = Color.Yellow;
                    //        break;
                    //    case 10:
                    //        myBrush.Color = Color.DarkRed;
                    //        myPen2.Color = Color.DarkRed;
                    //        break;
                    //    case 11:
                    //        myBrush.Color = Color.YellowGreen;
                    //        myPen2.Color = Color.YellowGreen;
                    //        break;
                    //    default:
                    //        myBrush.Color = Color.Silver;
                    //        myPen2.Color = Color.Silver;
                    //        break;
                    //}

                    if (this.nodeList[i].is_CH == true)          //if the node is a CH
                    {
                        if (this.nodeList[i].inEvent == 0)
                            g.FillRectangle(myBrush, myRectangle(c_x, c_y, 6, 6));
                        else
                        {
                            myBrush.Color = Color.Blue;
                            g.FillEllipse(myBrush, myRectangle(c_x, c_y, 6, 6));
                        }

                        if (drawCircleToolStripMenuItem.Checked == true)
                        {
                            r = zFact * (this.R / this.grid_X);        //Radious of the CH                        
                            g.DrawEllipse(myPen2, myRectangle(c_x, c_y, (2 * r), (2 * r)));
                        }
                        if (clusterTreeToolStripMenuItem.Checked == true)
                        {
                            if ((x == this.start_X) && (y == this.start_Y))
                                continue;
                            
                            x2 = (this.nodeList[i].Parent_CH - 1) % this.nodes_X;
                            y2 = (this.nodeList[i].Parent_CH - 1) / this.nodes_X;
                            c_x2 = zFact * x2 + offset_x;
                            c_y2 = zFact * y2 + offset_y;

                            //myPen3.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
                            myPen3.Color = Color.Black;
                            myPen3.Width = (float)1.5;
                            g.DrawLine(myPen3, c_x, c_y, c_x2, c_y2);
                          
                            if (this.nodeList[i].knowEvent == 1)
                            {
                               myPen3.DashStyle = System.Drawing.Drawing2D.DashStyle.Solid;
                               myPen3.Color = Color.Black;
                               myPen3.Width = 2;
                               g.DrawLine(myPen3, c_x, c_y, c_x2, c_y2);
                            }
                        }
                    }
                    else
                    {
                        if (this.noPointsToolStripMenuItem.Checked == false)
                        {
                            if (this.nodeList[i].inEvent == 0)
                                g.FillEllipse(myBrush, myRectangle(c_x, c_y, 4, 4));
                            else
                            {
                                myBrush.Color = Color.Blue;
                                g.FillEllipse(myBrush, myRectangle(c_x, c_y, 4, 4));
                            }
                        }
                    }
                }
                else
                {
                    g.DrawEllipse(myPen, myRectangle(c_x, c_y, 4, 4));    //if not in a cluster
                }
            }
        }
    }
}

