﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Forms;
using System.Configuration;
using System.Drawing;
using System.Drawing.Imaging;

using System.IO;

namespace VHHC
{
    public partial class VHHC : Form
    {
        private int grid_X, grid_Y, nodes_X, nodes_Y, start_X, start_Y, no_Nodes;
        private float R;
        private string node_File;
        private Nodes[] nodeList;
        private int offset_x = 20;
        private int offset_y = 60;
        private int zFact = 4; 

        public VHHC()
        {
            InitializeComponent();
            this.Paint += new PaintEventHandler(generate);
            this.Paint += new PaintEventHandler(count_Hexagans);
        }

        private void VHHC_Load(object sender, EventArgs e)
        {
            this.load_config_data();        //Load configuration data
        }

        private void configureToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Load the configuration data
            VHHC_Config config_form = new VHHC_Config();
            config_form.Visible = true;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void generateToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Invalidate();                //Generate the drawing
        }

        private RectangleF myRectangle(float x, float y, float width, float height)
        {
            return new RectangleF((x - (width / 2)), (y - (height / 2)), width, height);
        }

        private PointF[] Child_Points(float x, float y, float r)
        {
            float h, new_r;
            PointF[] my_hexa_points = new PointF[6];

            new_r = (r * this.zFact)/ this.grid_X;
            h = (float)((Math.Sqrt(3) * new_r ) / 2);
            my_hexa_points[0].X = x;
            my_hexa_points[0].Y = y - 2 * h;
            my_hexa_points[1].X = x + (float)Math.Sqrt(3) * h;
            my_hexa_points[1].Y = y - h;
            my_hexa_points[2].X = x + (float)Math.Sqrt(3) * h;
            my_hexa_points[2].Y = y + h;
            my_hexa_points[3].X = x;
            my_hexa_points[3].Y = y + 2 * h;
            my_hexa_points[4].X = x - (float)Math.Sqrt(3) * h;
            my_hexa_points[4].Y = y + h;
            my_hexa_points[5].X = x - (float)Math.Sqrt(3) * h;
            my_hexa_points[5].Y = y - h;

            return my_hexa_points;
        }

        private PointF[] Hexagonal_Coordinates(float x, float y, float r)
        {
            float h, new_r;
            PointF[] my_hexa_points = new PointF[6];

            new_r = (r * this.zFact)/this.grid_X;
            h = (float)((Math.Sqrt(3) * new_r ) / 2);
            my_hexa_points[0].X = x - (new_r/2);
            my_hexa_points[0].Y = y - h;
            my_hexa_points[1].X = x + (new_r/2);
            my_hexa_points[1].Y = y - h;
            my_hexa_points[2].X = x + new_r;
            my_hexa_points[2].Y = y ;
            my_hexa_points[3].X = x + (new_r/2);
            my_hexa_points[3].Y = y + h;
            my_hexa_points[4].X = x - (new_r/2);
            my_hexa_points[4].Y = y + h;
            my_hexa_points[5].X = x - new_r;
            my_hexa_points[5].Y = y;

            return my_hexa_points;

        }
        /*----------------------------------------------------------------------*
         * This function load configuration data from the VHHC.exe.conf file    *
         *----------------------------------------------------------------------*/
        private void load_config_data()
        {
            this.grid_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Grid_X"));
            this.grid_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Grid_Y"));
            this.nodes_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes_X"));
            this.nodes_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes_Y"));
            this.start_X = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Start_X"));
            this.start_Y = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Start_Y"));
            this.R = float.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("R"));
            this.node_File = System.Configuration.ConfigurationManager.AppSettings.Get("Node_file");
            this.no_Nodes = int.Parse(System.Configuration.ConfigurationManager.AppSettings.Get("Nodes"));
        }

        /*----------------------------------------------------------------------*
         * This function load node data into the node array.                    *
         *----------------------------------------------------------------------*/
        private void loadData(int no_nodes, string node_file)
        {
            string data;
            string[] tmp_data = new string[8];
            
            this.nodeList = new Nodes[no_nodes];    //Generate the node array
            
            //Open file
            FileStream fs = new FileStream(node_file, FileMode.Open);
            //Use a stream reader
            StreamReader sReader = new StreamReader(fs, Encoding.ASCII);

            //For each node read data from the file
            for (int i = 0; i < no_nodes; i++)
            {
                data = sReader.ReadLine();
                tmp_data = data.Split(new Char[] { });  //Split data based on tabs
                               
                 if (int.Parse(tmp_data[1]) != 0)                 //If in a cluster
                 {
                    if (string.Compare(tmp_data[0], tmp_data[2]) == 0)    //If NID & CH_NID is same
                        //Set the node ID, cluster ID, parent CH NID, set as a CH
                        nodeList[i] = new Nodes(int.Parse(tmp_data[0]), int.Parse(tmp_data[1]), int.Parse(tmp_data[3]), true, true, int.Parse(tmp_data[4]));
                    else
                        //Set the node ID, cluster ID, no parent CH, set as a in cluster but not a CH
                        nodeList[i] = new Nodes(int.Parse(tmp_data[0]), int.Parse(tmp_data[1]), 0, false, true, int.Parse(tmp_data[4]));
                }
                 else
                     //Set the node ID, set as not a member of a cluster
                     nodeList[i] = new Nodes(int.Parse(tmp_data[0]), 0, 0, false, false, 0);
            }
            fs.Close();
        }

        protected void generate(object sender, PaintEventArgs e)
        {
                     //Zoom factor
            int x, y, x2, y2, c_x, c_y, c_x2, c_y2, color_id;
            float r;

            if (this.nodeList == null)          //Check whether data is not already loaded
                this.loadData(this.no_Nodes, node_File);   //Load node data from node file
            else
            {
                this.nodeList = null;           //If already loaded just diacard
                this.loadData(this.no_Nodes, node_File);   //Load node data from node file
            }

            Graphics g = e.Graphics;
            g.PageUnit = GraphicsUnit.Pixel;
            Rectangle border = new Rectangle(offset_x, offset_y, (nodes_X * zFact), (nodes_Y * zFact));
            Pen myPen = new Pen(Color.Black, 2 / g.DpiX);
            g.DrawRectangle(myPen, border);
            SolidBrush myBrush = new SolidBrush(Color.Black);
            Pen myPen2 = new Pen(Color.Black, 2 / g.DpiX);
            Pen myPen3 = new Pen(Color.Black, 1 / g.DpiX);

            if (countClustersToolStripMenuItem.Checked == false)
            {
                for (int i = 0; i < this.no_Nodes; i++)
                {
                    x = (this.nodeList[i].NID - 1) % this.nodes_X;
                    y = (this.nodeList[i].NID - 1) / this.nodes_X;
                    c_x = zFact * x + offset_x;
                    c_y = zFact * y + offset_y;

                    if (this.nodeList[i].inCluster == true)         //if the node is in a cluster
                    {
                        if(this.nodeList[i].is_CH == true)
                            color_id = this.nodeList[i].CID % 12;
                            //color_id = this.nodeList[i].Depth % 12;
                        else
                            color_id = this.nodeList[i].CID % 12;
                            //color_id = this.nodeList[i].depth % 12;

                        switch (color_id)
                        {
                            case 0:
                                myBrush.Color = Color.Black;
                                myPen2.Color = Color.Black;
                                break;
                            case 1:
                                myBrush.Color = Color.Red;
                                myPen2.Color = Color.Red;
                                break;
                            case 2:
                                myBrush.Color = Color.Blue;
                                myPen2.Color = Color.Blue;
                                break;
                            case 3:
                                myBrush.Color = Color.Brown;
                                myPen2.Color = Color.Brown;
                                break;
                            case 4:
                                myBrush.Color = Color.DarkBlue;
                                myPen2.Color = Color.DarkBlue;
                                break;
                            case 5:
                                myBrush.Color = Color.DarkGreen;
                                myPen2.Color = Color.DarkGreen;
                                break;
                            case 6:
                                myBrush.Color = Color.Green;
                                myPen2.Color = Color.Green;
                                break;
                            case 7:
                                myBrush.Color = Color.DarkOrange;
                                myPen2.Color = Color.DarkOrange;
                                break;
                            case 8:
                                myBrush.Color = Color.DeepPink;
                                myPen2.Color = Color.DeepPink;
                                break;
                            case 9:
                                myBrush.Color = Color.Yellow;
                                myPen2.Color = Color.Yellow;
                                break;
                            case 10:
                                myBrush.Color = Color.DarkRed;
                                myPen2.Color = Color.DarkRed;
                                break;
                            case 11:
                                myBrush.Color = Color.YellowGreen;
                                myPen2.Color = Color.YellowGreen;
                                break;
                            default:
                                myBrush.Color = Color.Silver;
                                myPen2.Color = Color.Silver;
                                break;
                        }

                        if (this.nodeList[i].is_CH == true)          //if the node is a CH
                        {
                            g.FillRectangle(myBrush, myRectangle(c_x, c_y, 6, 6));

                            if (drawCircleToolStripMenuItem.Checked == true)
                            {
                                r = zFact * (this.R / this.grid_X);        //Radious of the CH
                                
                                
                                g.DrawEllipse(myPen2, myRectangle(c_x, c_y, (2 * r), (2 * r)));
                            }
                            if (clusterTreeToolStripMenuItem.Checked == true)
                            {
                                if ((x == this.start_X) && (y == this.start_Y))
                                    continue;

                                x2 = (this.nodeList[i].Parent_CH - 1) % this.nodes_X;
                                y2 = (this.nodeList[i].Parent_CH - 1) / this.nodes_X;
                                c_x2 = zFact * x2 + offset_x;
                                c_y2 = zFact * y2 + offset_y;

                                g.DrawLine(myPen3, c_x, c_y, c_x2, c_y2);
                            }
                        }
                        else
                        {
                            if (this.noPointsToolStripMenuItem.Checked == false)
                                g.FillEllipse(myBrush, myRectangle(c_x, c_y, 4, 4));
                        }
                    }
                    else
                    {
                        g.DrawEllipse(myPen, myRectangle(c_x, c_y, 4, 4));    //if not in a cluster
                    }
                }
            }
        }

        private void count_Hexagans(object sender, PaintEventArgs e)
        {
            float midPoint_x, midPoint_y, x, y, min_x, max_x, min_y, max_y;
            int current = 0;
            int next = 0;
            PointF[] children;
            PointF[] cordinates;
            PointF[] pointList = new PointF[20000000];
            Random random = new Random();
       
            midPoint_x = this.offset_x + this.zFact * this.start_X;
            midPoint_y = this.offset_y + this.zFact * this.start_Y;

            pointList[current] = new PointF(midPoint_x, midPoint_y);
            next++;

            Graphics g = e.Graphics;
            g.PageUnit = GraphicsUnit.Pixel;
            SolidBrush myBrush = new SolidBrush(Color.LightBlue);
            Pen myPen = new Pen(Color.Black);
            g.DrawEllipse(myPen, this.offset_x, this.offset_y, (this.zFact * this.nodes_X), (this.zFact * this.nodes_Y));
            
            if (countClustersToolStripMenuItem.Checked == true)
            {
                for (int i = 0; i < next; i++)
                {
                    cordinates = Hexagonal_Coordinates(pointList[current].X, pointList[current].Y, this.R);
                      
                    g.FillPolygon(myBrush, cordinates);
                    g.DrawPolygon(myPen, cordinates);
                    
                    children = Child_Points(pointList[current].X, pointList[current].Y, this.R);

                    min_x = this.offset_x;
                    min_y = this.offset_y;
                    max_x = this.zFact * this.nodes_X + this.offset_x;
                    max_y = this.zFact * this.nodes_Y + this.offset_y;
                    for (int j = 0; j <3; j++)
                    {
                        x = children[j].X;
                        y = children[j].Y;


                        if ((x >= min_x) && (x <= max_x) && (y >= min_y) && (y <= max_y) )
                        {
                             if (Math.Sqrt((this.start_X * this.zFact - x) * (this.start_X * this.zFact - x) + (this.start_Y * this.zFact - y) * (this.start_Y * this.zFact - y)) <= 50 * this.zFact)
                            {
                                 if (random.Next(3) != 0)
                                {
                                    pointList[next] = children[j];
                                    next++;
                                }
                            }
                        }
                   }
                    current++;
                }
            }
        }
    }
}
