#include "types.h"

#define STARTX		500		//x value of the starting node
#define STARTY		500		//y value of the starting node

#define MAX_HOPS	1		//Maximum no of hops within cluster
#define MAX_TTL		3		//Max no of hops to propagate the cluster formation bcast
#define NO_CCHS		6		//No of candidate CHs for level 1

#define NONODES		5000		//Number of nodes in the network

#define DELAY_CCH	900		//Delay to wait before forming a new cluster
#define TIMEOUT		700		//Time to wait befor selecting CCHs
#define RANDOM_WAIT	100		//random time to wait before broadcasting it self as CH

#define SHOW_NODE_DATA	0		//If 1 show node data on terminal
#define USE_NODE_FILE	1		//If 1 use pregenerated node file
#define USE_COLLISIONS	1		//If 1 consider node collisions

void init(uchar use_file);
void add_event(uchar event_type, int start_time, uint nid, uint cid, uint ch_nid, Hie_CID h_cid, uchar tree_depth, uchar node_depth, uchar ttl, uint parent_cid, uint parent_ch_nid, Hie_CID parent_h_cid);
void remove_event(uchar event_type, uint start_time, uint nid);
void process_event_list();
void add_nodes_to_cluster(uint start_time, uint nid, uint cid, uint ch_nid, uchar tree_depth, uchar node_depth, uchar ttl);
void forward_bcast_cluster(uint start_time, uint nid, uint cid, uint ch_nid, uchar ttl, uchar node_depth);
void send_ACK_as_CCH(uint nid, uint cid, uint ch_nid);
void select_child_CHs(uchar event_time, uchar no_cchs, uint parent_cid, uint parent_ch_nid, Hie_CID parent_h_cid, uchar tree_depth, uchar node_depth);
void calculate_circularity(uchar file);
int next_hop(Hie_CID dest_add, uint current_nid, uint sender_nid);
uchar send_data();
void inform_neighbors(uint nid, uchar range);
void bubble_sort(nei_status *neigh, int n);
void print_nodes(uchar pnt_console, uchar file);
void print_cluster_energy();
void mark_collision_region(uint nid1, uint nid2);
char is_in_collision(uint nid);
void opti_none_cluster_nodes();
void assign_key_id();
uint nodes_without_CH(uchar use_kps);
void print_no_common_keys();	
