#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "types.h"
#include "kps.h"

key_index *compromized_keys;	//hold the list of compromized nodes
uint no_compromized_keys = 0;			//no of compromized nodes

/*----------------------------------------------------------------------*
 * Following function determines a commom key given 2 key blocks 	*
 * a 	-	List of key indexes from node a				*
 * b 	-	List of key indexes from node b				*
 * k	-	No of keys in a key block				*
 * p 	- 	is the p of TD(k,p)                                     *
 * key_id -	Is the key id of the common key. If no common key	*
 * key_id -	Is the key id of the common key. If no common key	*
 * 		exist will be set to -1					*
 * Returns 	1 if common key exist, else 0				* 				
 *----------------------------------------------------------------------*/
int common_key(key_index a, key_index b, uint *com_key)
{
	int i, j;
	
        for(i = 0 ; i < M; i++)
        {
            for(j = 0 ; j < M; j++)
            {
                if(a.key_IDs[i] == b.key_IDs[j])
                {
                   *com_key = a.key_IDs[i]; 
                    return 1;
                }
            }
        }
        
        *com_key = 0; 
            return 0;
}

/*----------------------------------------------------------------------*
 * Following function determines the number of commom keys given z 	*
 * number of key blocks from 2 sensor nodes.				*
 * Each block in node a will be compared against each node in node b	*
 * z 	-	No of key blocks in a node				*
 * a 	-	List of key indexes from node a				*
 * b 	-	List of key indexes from node b				*
 * k	-	No of keys in a key block				*
 * p 	- 	is the p of TD(k,p)                                     *
 * Returns 	no of common key, 0 if no common key exist		* 				
 *----------------------------------------------------------------------*/
int no_common_key(key_index a, key_index b)
{
	int i, j;
	uchar no_keys = 0;

	 for(i = 0 ; i < M; i++)
        {
            for(j = 0 ; j < M; j++)
            {
                if(a.key_IDs[i] == b.key_IDs[j])
                    no_keys++;
            }
        }
	return no_keys;				//if no common key is found return 0
}

/*
uchar add_compromized_blocks(key_index block[MAX_Z], uchar p, uchar k, uchar z)
{
	int l, x;
	uchar i, j;

	if(compromized_keys == NULL)		//if memory is not already allocated
		compromized_keys = (key_index *)malloc(sizeof(key_index) * k * MAX_Z * COMP_NODES);	//hold the list of compromized nodes
	
	if(compromized_keys == NULL)		//if unable to allocate memory
	{
		printf("Unable to allocate memeory, add_compromized_blocks(). Terminating....\n");
		exit(1);
	}

	if(no_compromized_keys == (k * MAX_Z * COMP_NODES))	//If no more nodes can be added
		return 0;
	else						//if enough space is available add
	{
		for(l = 0 ; l < z; l++)		//For each key block
		{
			i = block[l].a;
			j = block[l].b;

			for(x = 0 ; x < k ; x++)	//for 0 <= x <= k -1 
			{
				compromized_keys[(no_compromized_keys + (l * k) + x)].a = x;
				compromized_keys[(no_compromized_keys + (l * k) + x)].b = (((i * x) + j) % p);
			}	
		}
		no_compromized_keys += z * k;	//Increment the counter
		return 1;
	}
}	
*/
