#define E_CIRCUIT	50.0		//Energy consumed by radio circuit for 1 bit. Values are in nano Jule
#define E_AMP_FS	0.01		//Energy for nJ/bit/m^2	- this is for the free space model. Values are in nano Jule
#define E_AMP_MP	0.0000013	//Energy for nJ/bit/m^4	- this is for the multi-path fading model. Values are in nano Jule
#define E_NODE		2000000000	//Initial energy of a node - in nano Jule
#define	T_RANGE		87.7		//Threshold distance to use the multipath fading model
#define	RF_POWER_LP	-22.0		//RF power of the transmeter when at Low Power state
#define	RF_POWER_HP	-22.0		//RF power of the transmeter when at High Power state
#define MY_N		2.2		//Path loss exponent
#define	REC_SENSITIVITY	-90.0		//Receiver sensitivity in dBm
#define USE_NOISE       0               //If 1 - use of noise
#define MY_K            0.0000989       //K if free space equation
#define RSSI_VAR        0.0             //Maximum variation in RSSI       

float energy_to_receive(int no_bits);
float energy_to_transmit(int no_bits, float distance);
char RSSI(float distance, unsigned char lp); 
float transmission_range(unsigned char lp);
