#define GRIDX		5	//Unit in X direction of grid
#define GRIDY		5	//Unit in Y direction of grid
#define NODESX		201	//No of nodes in X axis
#define NODESY		201	//No of nodes in y axis. Total no of nodes = NODESX * NODESY

#define MAX_ROUTES 		100	// Maximum no of routing entries 
#define MAX_VSN_ENTRIES         50      //Maximum number of VSN entries
        
#define DATA_PACKET_SIZE  	800     // Data Packet size in bits
#define CLUSTER_BCAST_SIZE	80	// Cluster formation broadcast size in bits
#define CLUSTER_ACK_SIZE	40	// ACK size in bits
#define CLUSTER_FORM_SIZE	120	// Cluster formation Size in bits
#define CLUSTER_OPTI_SIZE	40	// Cluster optimization message size in bits
#define VSN_FORM_SIZE           120	// VSN formation message size in bits
#define NO_COLLISION_NODES	4000	// No of nodes in the collision region

#define MAX_RND_TIME	25	//Maximum random wait time
#define	BIAS_POINT	0	//New time will be (Time - Bias Point). Should be 0 if no RSSI 

#define NODEFILE1       "nodes.txt"
#define NODEFILE2       "nodes_opt.txt"
#define CIRCLEFILE1	"circular.txt"
#define CIRCLEFILE2	"circular_opt.txt"
#define	NODELIST	"input_nodes.txt"
#define	ENERGYFILE	"energy1.txt"	//Store energy status after cluster formation

typedef unsigned char uchar;	//Define uchar
typedef unsigned int uint;	//Define uint

typedef struct {                //Data struture of hierarchocal CID
    uint id[4];
} Hie_CID;

typedef struct {    //Data struture of routing entry
    uchar valid;    //Valid indicate the status of the routing entry. Status is indicated by follwoing combination of bits
                    // Low in Energy|Learn from neighbor| Route to Parent CH |Valid Route
                    // bit is 0 is not set. Is 1 if set.
                    // Valid = 0 (0000)- Route is not valid
                    // Valid = 1 (0001)- Router is valid
                    // Valid = 3 (0011)- Route is valid & towards the parent CH
                    // Valid = 5 (0101)- Router is valid & lean from neighbor
                    // Valid = 9 (1001)- Router is valid but should be avoided whenever possible
                    // Valid = 13(1101) -Router is valid but should be avoided whenever possible  
                    // Valid = 11 (1011)- Router is valid & to the parent CH. But should be avoided whenever possible
                    // Valid = 2 (010), 4 (100), 6 (101), 7 (111), 8 (1000), 10 (1010), 12 (1100), 14 (1110), 15 (1111)- these
                    //  status can't exist 
    uint NID;       //Neighbors NID
    Hie_CID H_CID;  //Neighbor Hierarchical CID	
    uint learn_from;    //Learn from        
    uchar hops;     //Number of hops to the destination CH
} router_entry;

typedef struct {    //Data structure for VSN to CH Mapping
    uchar VSN;  //VSN ID    
    uint NID;
    uchar node_type ;   //Child node (2) or CH (1)
} vsn_entry;

typedef struct {    //Data struture of a node
    uint NID;   
    uint CID;
    Hie_CID H_CID;
    Hie_CID Link_H_CID;        
    uint CH_NID;
    uint parent_CH_NID;	//This will be used only if node is a CH
    uchar tree_depth;
    uchar node_depth;      
    uchar link_depth;
    uint no_broadcasts;
    uint no_ACKs;
    uint no_child_nodes;	
    uchar no_routing_entries;
    uchar no_vsn_entries;
    uint no_msg_forward;
    uint no_CCHs;
    uint CCHs[200];         //Hold the candidate CHs       
    router_entry routing_table[MAX_ROUTES];        
    vsn_entry vsn_table[MAX_VSN_ENTRIES];       
    float energy;
    uchar node_dead;        //Will be 1 if node is dead       
    uint marked_bcast_by_CID;
    uint last_bcast_for_CID;
    uint heard_ACK_for_CID;
    uchar send_ACK_for_CID;
    uchar send_tree_opt_msg;
    uchar in_event;         //Type of event detected
    uchar know_event;       //I know about this event type
    uchar send_routing_info;
} node;

typedef struct {            //Data struture of a data packet
    uint source_NID;
    Hie_CID source_H_CID;
    uint dest_NID;
    Hie_CID dest_H_CID;
} packet;

typedef struct {	//Data struture of neighbor status
    uchar hops;
    uint nei_NID;
} nei_status;

typedef struct EVENT{   //Data struture of an event
    struct EVENT *next;
    uchar event_type;	//Type of event. 1 - cluster formation, 2 - timeout, 3 - optimization
    uint time;
    uint NID;
    uint CID;
    Hie_CID H_CID;
    uint CH_NID;
    uchar tree_depth;
    uchar node_depth;
    uchar TTL;
    uint parent_CID;
    uint parent_CH_NID;
    Hie_CID parent_H_CID;
} event;

typedef struct {    //Data struture of a region
    int minx;
    int maxx;
    int miny;
    int maxy;
} region;

Hie_CID generate_CID(Hie_CID parent_ID, uint child_no, uchar tree_depth);
uchar hop_distance(Hie_CID source_add, Hie_CID dest_add);
region get_node_region(uint x, uint y, float r);
char CID_to_symbol_mapping(int CID);
uint last_event_time(uchar tree_depth, uchar no_CCHs, uint cluster_time, uint CCH_delay);
char random_wait_time();
void bubble_sort(nei_status *neigh, int n);
