#include "types.h"

#define STARTX		100	//x value of the starting node
#define STARTY		100	//y value of the starting node

#define MAX_HOPS	1	//Maximum no of hops within cluster
#define MAX_TTL		3	//Max no of hops to propagate the cluster formation bcast
#define NO_CCHS		6	//No of candidate CHs for level 1
#define CH_CH_R_FACT    3       //Maximum distance between two CHs
#define NONODES		5000	//Number of nodes in the network

#define NO_EVENT_NODES     500    //Number of nodes reading the same event
#define NO_OF_PACKETS      100000 //Number of data packets to send 

//Follwoing 2 paramters need to be set depending on whether RSSI is used or not 
#define DELAY_CCH	200	//Delay to wait before forming a new cluster                
#define TIMEOUT		100	//Time to wait befor selecting CCHs
#define RANDOM_WAIT	100	//random time to wait before broadcasting it self as CH

#define SHOW_NODE_DATA	0	//If 1 show node data on terminal
#define USE_NODE_FILE	1	//If 1 use pregenerated node file
#define USE_COLLISIONS	1	//If 1 consider node collisions
#define USE_HP          0      //If 1 use High Power for CH-to-CH communication

void init(uchar use_file);
void add_event(uchar event_type, int start_time, uint nid, uint cid, uint ch_nid, Hie_CID h_cid, uchar tree_depth, uchar node_depth, uchar ttl, uint parent_cid, uint parent_ch_nid, Hie_CID parent_h_cid);
void remove_event(uchar event_type, uint start_time, uint nid);
uchar process_event_list();
void add_nodes_to_cluster(uint start_time, uint nid, uint cid, uint ch_nid, uchar tree_depth, uchar node_depth, uchar ttl);
void forward_bcast_cluster(uint start_time, uint nid, uint cid, uint ch_nid, uchar ttl, uchar node_depth);
void send_ACK_as_CCH(uint nid, uint cid, uint ch_nid);
void select_child_CHs(uchar event_time, uchar no_cchs, uint parent_cid, uint parent_ch_nid, Hie_CID parent_h_cid, uchar tree_depth, uchar node_depth);
void calculate_circularity(uchar file);
void print_nodes(uchar pnt_console, uchar file);
void print_cluster_energy();
void mark_collision_region(uint nid1, uint nid2);
char is_in_collision(uint nid);
void opti_cluster_tree(uint nid, uint CH_nid, uchar tree_depth, uchar node_depth, uchar ttl);
void opti_none_cluster_nodes();
void update_child_nodes();
void form_my_own_cluster();
double total_energy();

//Following functions are related to routing
int next_hop(Hie_CID dest_add, int current_nid, int sender_nid);
void send_data();
unsigned char send_data_packet(packet data_packet);
void form_vsn();
uchar send_form_vsn_msg(packet data_packet);
void send_vsn_unicast_data();
void send_vsn_multicast_data();
uchar send_vsn_multicast_packet(packet data_packet);
void inform_neighbors();

void form_second_cluster_tree(uchar tree_depth);
void add_ch_to_tree(uint nid, uint parent_nid, uchar tree_depth, uchar link_depth, Hie_CID h_cid);

void discover_neighbors_of_link(uchar tree_depth);
void send_link_info(uint nid, uchar tree_depth);
void who_died(uchar d);
