#define E_CIRCUIT	50.0		//Energy consumed by radio circuit for 1 bit. Values are in nano Jule
#define E_AMP_FS	0.01		//Energy for nJ/bit/m^2	- this is for the free space model. Values are in nano Jule
#define E_AMP_MP	0.0000013	//Energy for nJ/bit/m^4	- this is for the multi-path fading model. Values are in nano Jule
#define E_NODE		2000000000	//Initial energy of a node - in nano Jule
#define	T_RANGE		87.7		//Threshold distance to use the multipath fading model
#define	T_ENERGY	50.0		//Energy threshold to use a different path (given as a %)
#define D0		1.0		//Close-in distance in meters
#define	RF_POWER	-24.0		//RF power of the transmeter at D0 (close-in distance)
#define N		2		//Path loss exponent
#define	REC_SENSITIVITY	-90.0		//Receiver sensitivity in dBm

float energy_to_receive(int no_bits);
float energy_to_transmit(int no_bits, float distance);
unsigned char RSSI(float distance); 
