#define GRIDX		6		//Unit in x direction
#define GRIDY		6		//Unit in y direction
#define NODESX		101		//No of nodes in X axis
#define NODESY		101		//No of nodes in y axis.         Total no of nodes = NODESX * NODESY

#define MAXROUTES 		20	//Maximum no of routing entries 
#define DATA_PACKET_SIZE  	1600    // Data Packet size in bits
#define CLUSTER_BCAST_SIZE	160	// Cluster Formation Size in bits
#define NO_COLLISION_NODES	1500	//No of nodes in the collision region

#define NODEFILE1       "nodes.txt"
#define NODEFILE2       "nodes_opt.txt"
#define CIRCLEFILE1	"circular.txt"
#define CIRCLEFILE2	"circular_opt.txt"
#define	NODELIST	"input_nodes.txt"
#define	ENERGYFILE	"energy.txt"		//Store energy status after cluster formation

#define MAX_RND_TIME	5		//Maximum random wait time
#define	BIAS_POINT	-2		//New time will be Time - BiasPoint

typedef unsigned char uchar;	//Define uchar
typedef unsigned int uint;	//Define uint

typedef struct {
	uint id[3];
} Hie_CID;

typedef struct {
	uchar valid;	//Valid indicate the status of the routing entry. Status is indicated by follwoing combination of bits
				// Low in Energy|Learn from neighbor| Route to Parent CH |Valid Route
				// bit is 0 is not set. Is 1 if set.
       				// Valid = 0 (0000)- Route is not valid
				// Valid = 1 (0001)- Router is valid
				// Valid = 3 (0011)- Route is valid & towards the parent CH
				// Valid = 5 (0101)- Router is valid & lean from neighbor
				// Valid = 9 (1001)- Router is valid but should be avoided whenever possible
				// Valid = 13(1101) -Router is valid but should be avoided whenever possible  
				// Valid = 11 (1011)- Router is valid & to the parent CH. But should be avoided whenever possible
				// Valid = 2 (010), 4 (100), 6 (101), 7 (111), 8 (1000), 10 (1010), 12 (1100), 14 (1110), 15 (1111)- these
				//  status can't exist 
	Hie_CID nei_H_CID;	//Neighbor Hierarchical CID
	int nei_NID;		//Neighbors NID
} router_entry;

typedef struct {
	uint NID;
	uint CID;
	Hie_CID H_CID;
	uint no_broadcasts;
	uint no_ACKs;
	uint CH_NID;
	uint parent_CH_NID;			//This will be used only if node is a CH
	uint no_child_nodes;
	uchar tree_depth;
	uchar no_routing_entries;
	router_entry routing_table[MAXROUTES];
	float energy;
	uint no_msg_forward;
	uchar sent_inform_neighbor;
	uchar node_dead;		//Will be 1 if node is dead
	uint marked_bcast_by_CID;
	uint last_bcast_for_CID;
	uint heard_ACK_for_CID;
	uchar send_ACK_for_CID;
	uchar send_tree_opt_msg;
	uint CCHs[200];                          //Hold the candidate CHs
	uint no_CCHs;
} node;

typedef struct {
	uint source_NID;
	Hie_CID source_H_CID;
	uint dest_NID;
	Hie_CID dest_H_CID;
} packet;

typedef struct {				//Neighbor status
	uchar hops;
	uchar low_energy;		//if 1 node is low in energy
	uchar parent;			//Entry learn from parent CH
	uchar child;			//Entry learn from child CH
	uchar neigh;			//Entry lean from neighbor
	uint nei_NID;
} nei_status;

typedef struct EVENT{
	struct EVENT	*next;
	uchar event_type;		//Type of event. If 1 cluster formation event if 2 timeout event 
	uint time;
	uint NID;
	uint CID;
	Hie_CID H_CID;
	uint CH_NID;
	uchar depth;
	uchar TTL;
	uint parent_CID;
	int parent_CH_NID;
	Hie_CID parent_H_CID;
} event;


typedef struct {
	int minx;
	int maxx;
	int miny;
	int maxy;
} region;

Hie_CID generate_CID(Hie_CID parent_ID, uint child_no, uchar depth);
region get_node_region(uint x0, uint y0, uchar r);
char CID_to_symbol_mapping(int CID);
uint last_event_time(uchar depth, uchar no_CCHs, uint cluster_time, uint CCH_delay);
char random_wait_time();
