#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "types.h"
#include "energy.h"

/*----------------------------------------------------------------------*
 * Following function calculate the residual energy of a given node	*
 * node_energy	-	Current energy value of the node		*
 *----------------------------------------------------------------------*/
float residual_energy(float node_energy)
{
	return ((node_energy / E_NODE) * 100);
}

/*----------------------------------------------------------------------*
 * Following function calculate the amount of energy required to receive*
 * a data packet of a geven length					*
 * no_bits - no of bits							*
 *----------------------------------------------------------------------*/
float energy_to_receive(uint no_bits)
{
	return (float)(no_bits * E_CIRCUIT);
}

/*----------------------------------------------------------------------*
 * Following function calculate the amount of energy required to 	*
 * transmit a data packet of given size and to a given distance		* 
 * If the distance is less than R * CH_CH_R_FACT then free space model	*
 * is used. Otherwice multi=path fading model is used			*
 * no_bits - no of bits to transmit					*
 * distace - distance between communicationg nodes or maximum 		*
 * transmission range 							*
 * fs_or_mp - Fress space model or multi-path model to use		*
 * if fs_or_mp = 0 free space						*
 * if fs_or_mp = 1 multi-path						*  
 *----------------------------------------------------------------------*/
float energy_to_transmit(uint no_bits, float distance)
{
	float circuit_energy, amp_energy;

	circuit_energy = (float)(no_bits * E_CIRCUIT);	
	
	if(distance < T_RANGE)						//If below threshold use free space model
		amp_energy = no_bits * E_AMP_FS * distance * distance;
	else								//Else use multipath fading model
		amp_energy = no_bits * E_AMP_MP * pow(distance, 4);
	
	return (amp_energy + circuit_energy);
}

