/*----------------------------------------------------------------------*
 * This header file defines the global parameters and data strctures	*
 * Set following parameter values appropriately 			*
 *----------------------------------------------------------------------*/

//----------------- Node related parameters-----------------------------
#define GRIDX		6		//Unit in x direction
#define GRIDY		6		//Unit in y direction
#define NODESX		30		//No of nodes in X axis
#define NODESY		30		//No of nodes in y axis.         Total no of nodes = NODESX * NODESY
#define STARTX		15		//x value of the starting node
#define STARTY		15		//y value of the starting node
#define NODEPROB	2		//Node probability 1/x
#define R		30		//Communication radious of a node
#define CH_CH_R_FACT	3		//CH-to-CH communication range as a factor of node-to-node communication range

//----------------- Cluster related parameters-----------------------------
#define MAX_HOPS	1		//Max no of hops to propagate the message
#define MAX_TTL		3		//Maximum TTL should be equal to (2 x MAX_HOPS + 1)
#define CLUSTER_DELAY	1		//Cluster formation delay. 1 time unit

//----------------- Node energy related parameters------------------------------
#define E_CIRCUIT	50.0		//Energy consumed by radio circuit for 1 bit. Values are in nano Jule
#define E_AMP_FS	0.01		//Energy for nJ/bit/m^2 - this is for the free space model. Values are in nano Jule
#define E_AMP_MP	0.0000013	//Energy for nJ/bit/m^4 - this is for the multi-path fading model. Values are in nano Jule
#define E_NODE		2000000000	//Initial energy of a node - in nano Jule
#define T_RANGE		87.7		//Threshold distance to use the multipath fading model


//----------------- Routing related parameters------------------------------
#define MAXROUTES 		30	//Maximum no of routing entries 
#define DATA_PACKET_SIZE  	1600    // Data Packet size in bits
#define ACK_PACKET_SIZE  	40      // Data Packet size in bits
#define CLUSTER_BCAST_SIZE	48	// Cluster Formation Size in bits
#define KEY_INDEX_SIZE		64	// Size of key index in bits. Assume all 4 block IDs are send

//----------------- Simulation control parameters-----------------------------
#define USE_NODE_FILE	0	//Set to 1 if pregenerated node file to be used		
#define SHOW_NODE_DATA	1	//Set to 1 if node data to be shown on the terminal. Anyway will be dumped to a file		


//----------------- File names------------------------------------------------
#define NODEFILE        "nodes.txt"
#define CIRCLEFILE	"circular.txt"
#define	NODELIST	"input_nodes.txt"
#define	ENERGYFILE	"energy.txt"		//Store energy status after cluster formation
#define KEYFILE		"key_id.txt"
#define COM_KEYFILE	"common_keys.txt"


//----------------- Key distribution related parameters------------------------
#define USE_KPS		1		//Set to 1 if key predistribution to be used
#define NODE_COMP	0		//Set to 1 if nodes are compromized
#define INDEX_SIZE	2		//Size of key index in (x, y) format
#define BLOCK_KEYS	2 * 40		//List of keys in (x, y) format
#define MAX_Z		4
#define COMP_NODES	0		//Maximum no of compromized nodes


/*----------------------------------------------------------------------*
 * Definition of data structures		 			*
 *----------------------------------------------------------------------*/
typedef unsigned char uchar;	//Define uchar
typedef unsigned int uint;	//Define uint


typedef struct
{
	uint a;
	uint b;
	uchar used;
} key_index;

