/*----------------------------------------------------------------------*
 * Definition of data structures		 			*
 *----------------------------------------------------------------------*/

typedef struct {
	uint id[3];
} Hie_CID;

typedef struct {			//Neighbor status
	uchar hops;
	uchar parent;			//Entry learn from parent CH
	uchar child;			//Entry learn from child CH
	uchar neigh;			//Entry lean from neighbor
	uint nei_NID;
} nei_status;

typedef struct {
	uchar valid;		//Valid indicate the status of the routing entry. Status is indicated by follwoing combination of bits
				// Low in Energy|Learn from neighbor| Route to Parent CH |Valid Route
				// bit is 0 is not set. Is 1 if set.
       				// Valid = 0 (0000)- Route is not valid
				// Valid = 1 (0001)- Router is valid
				// Valid = 3 (0011)- Route is valid & towards the parent CH
				// Valid = 5 (0101)- Router is valid & lean from neighbor
				// Valid = 9 (1001)- Router is valid but should be avoided whenever possible
				// Valid = 13(1101) -Router is valid but should be avoided whenever possible  
				// Valid = 11 (1011)- Router is valid & to the parent CH. But should be avoided whenever possible
				// Valid = 2 (010), 4 (100), 6 (101), 7 (111), 8 (1000), 10 (1010), 12 (1100), 14 (1110), 15 (1111)- these
				//  status can't exist 
	Hie_CID nei_H_CID;	//Neighbor Hierarchical CID
	uint nei_NID;		//Neighbors NID
} router_entry;

typedef struct {		
	uint NID;				//NID of a node
	uint CID;				//Cluster ID
	Hie_CID H_CID;				//Hierarchical cluster ID
	uint broadcasts;			//No of cluster formation broadcasts
	uint CH_NID;				//NID of the CH
	uint parent_CH_NID;			//Will be used only if node is a CH
	uint no_child_nodes;			//No of child nodes if the node is a cluster head
	uchar tree_depth;			//Depth in the cluster tree
	uint last_bcast_for;			//Last broadcast message was send for CID, used to prevent rebroadcasting the same message
	uint no_msg_forward ;			//No of data packets forwarded
	uchar no_routing_entries;		//If a CH no of entries in the rouing table
	router_entry routing_table[MAXROUTES];	//If a CH routing entries
	float energy;				//Current energy of a node
	uchar sent_inform_neighbor;		//Will be 1 if presence of my cluster is informed to neighbors
	uchar node_dead;			//Will be 1 if node is dead
	uchar no_key_blocks;			//No of key blocks
	key_index key_IDs[MAX_Z];		//List of key indexes save in (i, j) format
	key_index common_key_ID;		//Key id of the common key
	uchar no_key_to_CH;			//If 1, indicates that it was unable to join the CH since it didn't had a common key
} node;

typedef struct EVENT{				//Structure of an event
	struct EVENT	*next;			//Pointer to the next event in the event list
	uint time;				//Starting time of the event
	uint NID;				//NID of a node related to the event
	uint CID;				//CID of the cluster related to the event
	Hie_CID H_CID;				//Hierarchical CID of the related cluster
	uchar depth;				//Depth in the cluster tree for the related node
	uchar ttl;				//TTL value at the node bcasting
	uint parent_CID;			//CID of the parent CH
	Hie_CID parent_H_CID;			//Hierarchical CID of the parent CH
	uint parent_CH_NID;			//NID of the parent CH
} event;

typedef struct {				//Structure of a data packet
	uint source_NID;			//NID of the Source node
	Hie_CID source_H_CID;			//Hierarchical CID of the CH related to the source node
	uint dest_NID;				//NID of the destination node
	Hie_CID dest_H_CID;			//Hierarchical CID of the Ch related to the destination node
} packet;

/*----------------------------------------------------------------------*
 * Function definition. For details of each function look at the 	*
 * description before the implementation of function in simulator.c file*
 *----------------------------------------------------------------------*/
void init(uchar use_file);
void add_to_event_list(uint start_time, uint nid, uint cid, Hie_CID h_cid,  uchar depth, uchar ttl, uint parent_cid, uint parent_ch_nid, Hie_CID parent_h_cid);
void remove_from_event_list(uint start_time, uint nid);
void process_event_list();
void add_nodes_to_cluster(uint nid, uint CID, uint CH_NID, uchar depth, uchar ttl);
void select_child_CHs(uchar depth, uint parent_cid, Hie_CID parent_h_cid, uint parent_ch_nid);
void calculate_circularity();
void print_nodes(uchar pnt_console);
Hie_CID generate_CID(Hie_CID parent_ID, int child_no, int depth);
int next_hop(Hie_CID dest_add, int current_NID, int sender_NID);
void test_routing();
unsigned char send_data();
void inform_neighbors(int NID, int range);
void inform_energy_low(int NID, int range);
void print_cluster_energy();
void bubble_sort(nei_status *neigh, int n);
void assign_key_id();
uint nodes_without_CH(uchar use_kps);
void print_no_common_keys();	


//No of nodes to be selected as candidate CHs at each cluster fomation round. 
unsigned char no_new_nodes[30]	= {6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}; 
//unsigned char no_new_nodes[30]  = {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
//unsigned char no_new_nodes[30]  = {8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

//Time delay for forming clusters for a given depth. See all values to 0 if breadth first tree formation is used
unsigned int delay[30][3]= { 	{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0}	};
