#define INDEX_SIZE	2		//Size of key index in (x, y) format
#define BLOCK_KEYS	2 * 40		//List of keys in (x, y) format
#define KEYID_FILE	"key_id.txt"	//Key IDs will be saved in this file
#define MAX_Z		4

typedef unsigned char uchar;	//Define uchar
typedef unsigned int uint;	//Define uint

typedef struct {			//Hold the keys of a block
	uchar key_index[INDEX_SIZE];	//Key index
	uchar key_id[BLOCK_KEYS];		//List of key IDs
	uchar selected;		//whether the key block has been selected 0 - not selected, 1 - selected
} block;

typedef struct
{
	int g;
	int u;
	int v;
} guv;

typedef struct
{
	uint a;
	uint b;
} key_index;

void generate_key_IDs(uint p, uint k, uint b, block *key_block);
void dump_keys_ls(uint v, uint b, uint p, uint k, block *key_block);
void dump_keys_cmr(uint v, uint b, uint p, uint k, uchar z, block *key_block);
int emod(int a, int n);
guv ext_gcd(int a, int b);
int inv_mod(int a, int p);
int common_key(key_index x, key_index y, uint k, uint p, key_index *key_id);
int block_common_key(uchar z, key_index a[MAX_Z], key_index b[MAX_Z], uint k, uint p, key_index *key_id);

