#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "kps.h"

int main()
{
	uint v;		//no of uinque keys
	uint b;		//nodes of key blocks
	uint p;		//Primer no p of TD(k, p)
	uint k;		//No of keys in a block
	uchar z; 		//No of blocks to merge
	block *key_block;

	printf("Enter p (primer or prime power):");
	scanf("%d", &p);
	if(p < 2)
	{
		printf("Invalid p, Terminating....\n");
		exit(0);
	}
	printf("Enter k (no of keys per block):");
	scanf("%d", &k);
	if(k < 2)
	{
		printf("Invalid k, Terminating....\n");
		exit(0);
	}
	else if( k > (BLOCK_KEYS / 2) )
	{
		printf("Invalid k. k > (BLOCK_KEYS / 2). Change BLOCK_KEYS parameter in kps.h file & recompile. Terminating....\n");
		exit(0);
	}	 
	else if(k > p)				// k & p shuld be selected such that 2 <= k <= p
	{
		printf("Invalid k or p. k & p should be selected such that 2 <= k <= p). Terminating....\n");
		exit(0);
	}
	printf("Enter z (no of blocks per node):");
	scanf("%d", &z);
	if(z < 1)
	{
		printf("Invalid z, terminating....\n");
		exit(0);
	}
	
	v = k * p;
	b = p * p;

	//Allocate memory
	key_block = (block *)calloc(b, sizeof(block));
	if(key_block == NULL)                   //If memory not allocated
	{
		perror("Can't allocate memory:");
		exit(1);
	}
	

	generate_key_IDs(p, k, b, key_block);		//Generate key IDs and keys

	if(z == 1)
		dump_keys_ls(v, b, p, k, key_block);		//Dump keys to a file based on Lee-Stinson approach
	else
		dump_keys_cmr(v, b, p, k, z, key_block);	//Dump keys to a file based on Chakrabarti-Maitral-Roy approach

	if(key_block != NULL)
		free(key_block);
		
	return 0;
}
