#define GRIDX		6		//Unit in x direction
#define GRIDY		6		//Unit in y direction
#define R		18		//Communication radious of a node
#define TTL		2		//Max no of hops to propagate the message
#define NODESX		50		//No of nodes in X axis
#define NODESY		50		//No of nodes in y axis.         Total no of nodes = NODESX * NODESY

#define STARTX	25		//x value of the starting node
#define STARTY	25		//y value of the starting node

#define NODEPROB	1	//Node probability 1/x

#define CLUSTER_DELAY	1	//Cluster formation delay. 1 time unit

#define NODEFILE        "nodes.txt"
#define CIRCLEFILE	"circular.txt"
#define	NODELIST	"input_nodes.txt"

typedef struct {
	int NID;
	int CID;
	int broadcasts;
	int CH_NID;
	int parent_CH_NID;		//This will be used only if node is a CH
	int no_child_nodes;
	int tree_depth;
	int last_bcast_for;
} node;

typedef struct EVENT{
	struct EVENT	*next;
	int time;
	int NID;
	int CID;
	int depth;
	int ttl;
	int parent_CID;
	int parent_CH_NID;
} event;

void init();
void add_to_event_list(int start_time, int NID, int CID, int depth, int ttl, int parent_CID, int parent_CH_NID);
void remove_from_event_list(int start_time);
void process_event_list();
void print_nodes();
void add_nodes_to_cluster(int nid, int CID, int CH_NID, int depth, int hops, int ttl);
void select_child_CHs(int depth, int parent_CID, int parent_CH_NID);
void calculate_circularity();

int no_new_nodes[30]	= {6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}; 
int delay[30][3]	= { 	{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0}	};
