/*------------------------------------------------------------------------------*
 * Version - 6.0                                                                *
 * BY - Dilum Bandara                                                           *
 * Type - HHC - Breadth First tree formation & hierarchical naming              *
 *------------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "simulator.h"

node nodes[NODESX][NODESY];			//Hold the node information	
event *root;					//Root of the event list
int candidateCHs[625];         			//Hold the candidate CHs
int no_candidate_CHs = 0;       
char msg[100];
int nextCID = 1;
int current_time  = 0;
int last_event_time = 0;

int main()
{
	init();					//initialize nodes & link list
	while(1)				//Process the event list until no events are found
	{
		process_event_list();
	}
}

/*------------------------------------------------------------------------------*
 * Initialise the nodes & event list                                            *
 * Nodes may either randomly genrated or use from the pregenerated file         *
 *------------------------------------------------------------------------------*/
void init()
{
	int no_nodes_to_generate;			//No of nodes to generate
	int count, x, y, i, j, start_nid, nid;
	FILE *nodes_fd;
	char str[10];
	
	count = 0;
	srand(time(NULL));                              //Set the seed for rand()
	
	//Set all the nodes to 0
	for (i = 0; i < NODESX ; i++)
	{
		for(j = 0 ; j < NODESY ; j++)
		{
			nodes[i][j].CID = 0;                    // Initially set all nodes to 0
			nodes[i][j].NID = 0;                    // Set NIDs from left to right. Set nos from 1
			nodes[i][j].broadcasts = 0;
			nodes[i][j].CH_NID = 0;
			nodes[i][j].parent_CH_NID = 0;
			nodes[i][j].no_child_nodes = 0;
		}
	}
	
	
	//Set the given no of nodes	
	no_nodes_to_generate = (NODESX * NODESY) /  NODEPROB;
	//no_nodes_to_generate = 7500;

//Enable following code segment if nodes are to be generated randomly
//---------------------------------------------------------------------

	while (1)
	{
		x = rand() % NODESX;
		y = rand() % NODESY;
		if(nodes[x][y].NID == 0)
		{		
			nodes[x][y].NID = y * NODESX + x + 1;   // Set NIDs from left to right. Set nos from 1
			count++;
		}
		if(count == no_nodes_to_generate)
			break;
	}

        if(nodes[STARTX][STARTY].NID == 0)	//See whether the starting node exist
	{
		printf("Can't continue. Intial node doesn't exist\n");
		exit(1);
	}

//----------------------------------------------------------------------

//Enable follwoing code block if previously generated node file to be used
//----------------------------------------------------------------------	
/*
	nodes_fd = fopen(NODELIST, "r");
	if(nodes_fd == NULL)
	{
		perror("ERROR:");
		exit(1);
	}
	
	for(i = 0; i < 	no_nodes_to_generate; i++)
	{
		fgets(str, 10, nodes_fd);
		nid = atoi(str);
		x = (nid - 1) % NODESX;
		y = (nid - 1) / NODESX;
		nodes[x][y].NID = y * NODESX + x + 1;   // Set NIDs from left to right. Set nos from 1
	}
	fclose(nodes_fd);
*/
//-------------------------------------------------------------------------------

	root = (event *)malloc(sizeof(event));
	if(root == NULL)
	{
		perror("Error while allocating memory\n");
		exit(1);
	}
	root->next = NULL;		
	
	//Add the first event to the event list
	start_nid = STARTY * NODESX + STARTX + 1;
	add_to_event_list(1, start_nid, 1, 0, TTL, 0, 0);
	//add_to_event_list(1, start_nid, 1, root_H_CID, 0, TTL, 1, start_nid);
}

/*------------------------------------------------------------------------------*
 * Add events to event list                                                     *
 * Implementation of this function will slightly vary depending on the tree     *
 * formation approach (breadth-first, depath first, etc.)                       *
 * This implementation is for the Breadth-first                                 *
 *------------------------------------------------------------------------------*/
void add_to_event_list(int start_time, int NID, int CID, int depth, int ttl, int parent_CID, int parent_CH_NID)
{
	event *new, *current, *previous;

	last_event_time = start_time;		//Always add as the last event
	current = root;
	previous = NULL;
	while( (current->next != NULL) && (current->time < start_time))
	{
		previous = current;
		current = current->next;
	}			
	new = (event *)malloc(sizeof(event));	
	if(new == NULL)
	{
		perror("Error while allocating memory\n");									
		exit(1);
	}
	new->time = start_time;
	new->NID = NID;
	new->CID = CID;
	new->depth = depth;
	new->ttl = ttl;
	new->parent_CID = parent_CID;
	new->parent_CH_NID = parent_CH_NID;
	
	if((current->next == NULL) && (current->time < start_time))
	{
		new->next = NULL;
		current->next = new;
	}
	else
	{
		new->next = current;
		previous->next = new;
	}
	if(previous == NULL)
		root->next = new;
}

/*------------------------------------------------------------------------------*
 * Remove from event list							*
 *------------------------------------------------------------------------------*/
void remove_from_event_list(int start_time)
{
	event *new, *current, *previous;

	if(root->next == NULL)
	{	
		printf("Event list is already empty\n");
		exit(1);
	}
	current = root;
	previous = NULL;
	while( (current->next != NULL) && (current->time < start_time))
	{
		previous = current;
		current = current->next;
	}
	if(current->next == NULL)
	{
		free(current);
		previous->next = NULL;
	}
	else
	{
		previous->next = current->next;
		free(current);
	}
}

/*------------------------------------------------------------------------------*
 * Process the event list starting from the first event				*
 *------------------------------------------------------------------------------*/
void process_event_list()
{
	event *next_event, *nevent;
	int x0, y0, parentx0, parenty0, parent_NID, next_route_no;
	unsigned char result;
		
	if(root->next == NULL)			//If no more events to handle print the data & exit
	{
		calculate_circularity();
		print_nodes();
		exit(0);	
	}
	else
	{		
		next_event = root->next;
		current_time = next_event->time;			//Set the current time
		x0 = (next_event->NID - 1) % NODESX;
		y0 = (next_event->NID - 1) / NODESX;
			 
		if(nodes[x0][y0].CID == 0)
		{
			nodes[x0][y0].CID = next_event->CID;		//Set the CID of the starting node		
			nodes[x0][y0].CH_NID = next_event->NID;		//Set me as my own CH
	       		nodes[x0][y0].tree_depth = next_event->depth;
	       		nodes[x0][y0].parent_CH_NID = next_event->parent_CH_NID;	
				 
			add_nodes_to_cluster(next_event->NID, next_event->CID, next_event->NID, next_event->depth, 1, next_event->ttl);	
			if(nodes[x0][y0].no_child_nodes == 0)
			{
				nodes[x0][y0].CID = next_event->parent_CID;
				nodes[x0][y0].CH_NID = next_event->parent_CH_NID;
	       			nodes[x0][y0].parent_CH_NID = 0;	
				nodes[x0][y0].tree_depth = (next_event->depth) - 1;
			}
			else
			{
				select_child_CHs(next_event->depth, next_event->CID, next_event->NID );
			}
		}
		remove_from_event_list(next_event->time);	
	}
}

/*------------------------------------------------------------------------------*
//Add nodes to cluster
 *------------------------------------------------------------------------------*/
void add_nodes_to_cluster(int nid, int cid, int CH_NID, int depth, int hops, int ttl)
{
	int x0, y0, minx, miny, maxx, maxy, no_of_neighbors, n, newx0, newy0, CH_x, CH_y, l, k, i;
	float length;
	int neighbors[625];					//No if 1-hop neighbors. This depends on tranmissions distance
								//So no of entries in the array (2 * r + 1)^2 -1
								//Will be valid untill communication distance is 12 time grid size
	no_of_neighbors = 0;	
	x0 = (nid - 1) % NODESX;
	y0 = (nid - 1) / NODESX;
	
	minx = x0 - (R/GRIDX) - 1;                              // 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
	if (minx < 0)                                           // Stay within the grid			
		minx = 0;
	maxx = x0 + (R/GRIDX) + 1;
	if(maxx >= NODESX)
		maxx = NODESX -1;

	miny = y0 - (R/GRIDY) - 1;                              // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
	if (miny < 0)                                           // Stay within the grid
		miny = 0;		
	maxy = y0 + (R/GRIDY) + 1;
	if(maxy >= NODESY)
		maxy = NODESY - 1;

	if(nodes[x0][x0].last_bcast_for == cid)			//Check whether the cluster formation message is already broadcasted
		return;						//If so discard
	else							//If not
	{	
		nodes[x0][y0].broadcasts++;                  	//Node is broadcastsing	
		nodes[x0][y0].last_bcast_for = cid;		//Set the CH who send the last broadcast
	}

	//Set CID for only neighboring nodes   
	for(l = miny; l <= maxy; l++)
	{
		for (k = minx; k <= maxx; k++)
		{
			length = sqrt((k - x0)*(k-x0)*(GRIDX * GRIDX) + (l - y0)*(l-y0)*(GRIDY * GRIDY));
			
			// If within communication range & if the node exist
			if (length <= R && (nodes[k][l].NID != 0) && (length != 0))     
			{
				//If Hops <  2 * MaxHops + 1
				if(hops != (2 * TTL + 1))
				{
		                	if(nodes[k][l].CID == 0)		//If not already a member of a cluster
					{
						neighbors[no_of_neighbors] = nodes[k][l].NID;
						no_of_neighbors++;
					}
					
					if(hops <= TTL)
					{
					   	//If not a member of a cluster assigned to the current cluster
		 				if(nodes[k][l].CID == 0)   
						{
							nodes[k][l].CID = cid;
							nodes[k][l].CH_NID = CH_NID;
							nodes[k][l].tree_depth = depth + 1;
							CH_x = (CH_NID - 1) % NODESX;
							CH_y = (CH_NID - 1) / NODESY;
							nodes[CH_x][CH_y].no_child_nodes++;
						}
					}
				}
				else	//If Hops = MaxHops * 2 + 1
				{
					if(nodes[k][l].CID == 0)        // If not a memeber of any cluster
					{
						//See whether it has already been seleted as a candidate to become a CH
                                                for( i = 0; i < no_candidate_CHs; i++)
						{
							if(candidateCHs[i] == nodes[k][l].NID)
								break;
						}
						if( i == no_candidate_CHs)
						{       
							candidateCHs[no_candidate_CHs] = nodes[k][l].NID;
							no_candidate_CHs++;
						}
					}	
				}
			}
		}
	}
	        
	for (n = 0; n < no_of_neighbors; n++)
	{
		newx0 = (neighbors[n] - 1) % NODESX;
		newy0 = (neighbors[n] - 1) / NODESX;
	
		//For each node find other 1-hop neighbors & keep forwarding cluster formation message
		hops++;
		depth++;
		add_nodes_to_cluster(neighbors[n], cid, CH_NID, depth, hops, ttl);
		depth--;
		hops--;
	}
}


/*------------ ---------------------------------------------------------------*
 * This function selecte candidate CHs                                        *
 *----------------------------------------------------------------------------*/
void select_child_CHs(int depth, int parent_CID, int parent_CH_NID)
{
	int no_new_CHs, next_CH_x, next_CH_y, next_CH, delay_next_cluster, j, l, new_time;
	int selected_CH_list[10];
	int no_selected_CHs = 0;
	int loops = 0;
	
	if(no_candidate_CHs == 0)		//If no nodes are there to be elected as CHs return function
		return;	
	
	if(depth < 30)				//If no of candidate CHs are given in the header file
		no_new_CHs= no_new_nodes[depth];		
	else					//if not use the last no given in the header file
		no_new_CHs = no_new_nodes[29];

	if(no_new_CHs > no_candidate_CHs)	//If no of possible CHs are less than what is given in the header file
		no_new_CHs = no_candidate_CHs;	//Generate the maximum possible no

	for(j = 0; j < no_new_CHs; j++)			//Select given no of candidate neighbors as CHs
	{
		while(1)
		{
			if(no_candidate_CHs == 0)			//If there are no candidate node who is not a member
				break;
			
			next_CH = rand() % (no_candidate_CHs); 		//Randomly select one of the nodes to be the CH
			next_CH_x = (candidateCHs[next_CH] - 1) % NODESX;
			next_CH_y = (candidateCHs[next_CH] - 1) / NODESX;
			
			if(nodes[next_CH_x][next_CH_y].CID != 0)	//If the selected candidate has already been assigned as a CH
			{	
				loops++;			
				if(loops == 200);	//Just keep looping until a possble one is found or until loop count exceeds. 
							//200 is just an aribiatory value just to prevent the loop form becoming infinite
					break;		//If so break the loop
				continue;
			}
			
			for(l = 0 ; l < no_selected_CHs ; l++)			//Check whether it has been already selected
			{
				if(selected_CH_list[l] == candidateCHs[next_CH])	//If so don't selecte again
					break;	
			}
			if(l != no_selected_CHs)			//If so diacard & select another
				continue;
			
			selected_CH_list[no_selected_CHs] = candidateCHs[next_CH];
                        no_selected_CHs++;
				
			nextCID++;					//generate the next CID
			if(depth < 30)
				delay_next_cluster = delay[depth][j];
			else
				delay_next_cluster = delay[29][j];
			
			//Set the timeing such that tree is formed using the Breadth-first tree formation
			new_time = last_event_time + delay_next_cluster + CLUSTER_DELAY;

			//Add to the event list
	 		add_to_event_list(new_time, candidateCHs[next_CH], nextCID, (depth + 1), TTL, parent_CID, parent_CH_NID);
			break;
		}
	}
	no_candidate_CHs = 0;
}


/*------------------------------------------------------------------------------*
 * This function either printer the node status on the terminal or print node   *
 * data to a text file named nodes.txt                                          *
 * symbols:                                                                     *
 * '.' - Indicate grid points with nodes                                        *
 * 'o' - Indicate nodes with a CH                                               *
 * '?' - Indicare nodes clusters that don't have a represnetable symbol         *
 * Cluster symbol followed by a . indicate CHs                                  *
 *------------------------------------------------------------------------------*/
void print_nodes()
{
        int i, j, retvalue, k;
	FILE *nodefd;
	nodefd = fopen(NODEFILE, "w");

	//Following code write node data to the text file	
	for (i = 0; i < NODESY ; i++)
	{
		for(j = 0 ; j < NODESX ; j++)
		{
			if(nodes[j][i].NID != 0)
			{
				retvalue = sprintf(msg, "%d\t%d\t%d\t%d\t%d\t%d\n", nodes[j][i].NID, nodes[j][i].CID, nodes[j][i].broadcasts, nodes[j][i].CH_NID, nodes[j][i].no_child_nodes, nodes[j][i].tree_depth);
				fputs(msg, nodefd);
			}
		}
	}
	fclose(nodefd);

	
//Disable follwing code segment to prevent if form writing to the terminal
//---------------------------------------------------------------------------
/*
	for (i = 0; i < NODESY ; i++)
	{
		for(j = 0 ; j < NODESX ; j++)
		{
			if(nodes[j][i].NID == 0)	
				printf(". ");
			else
			{
				switch (nodes[j][i].CID )
				{
					case 0:
						printf("o");
						break;
					case 1:	
						printf("1");
						break;
					case 2:
						printf("2");
						break;
					case 3:
						printf("3");
						break;
					case 4:
						printf("4");
						break;
					case 5:
						printf("5");
						break;
					case 6:
						printf("6");
						break;
					case 7:
						printf("7");
						break;
					case 8: 
						printf("8");
						break;
					case 9:
						printf("9");
						break; 
					case 10:
						printf("A");
						break;
					case 11:
						printf("B");
						break;
					case 12:
						printf("C");
						break;
					case 13:
						printf("D");
						break;
					case 14:
						printf("E");
						break;
					case 15:
						printf("F");
						break;
					case 16:
						printf("G");
						break;
					case 17: 
						printf("H");
						break;
					case 18: 
						printf("I");
						break;
					case 19:
						printf("J");
						break;
					case 20: 
						printf("K");
						break;
					case 21: 
						printf("L");
						break;
					case 22: 
						printf("M");
						break;
					case 23:
						printf("N");
						break;
					case 24:
						printf("O");
						break;
					case 25:
						printf("P");
						break;
					case 26:
						printf("Q");
						break;
					case 27:
						printf("R");
						break;
					case 28:
						printf("S");
						break;	
					case 29:
						printf("T");
						break;
					case 30:
						printf("U");
						break;
					case 31:
						printf("V");
						break;
					case 32:
						printf("W");
						break;
					case 33:
						printf("X");
						break;
					case 34:	
						printf("Y");
						break;
					case 35: 
						printf("Z");
						break;
					case 36:
						printf("*");
						break;
					case 37:
						printf("#");
						break;
					case 38:
						printf("$");
						break;
					case 39:
						printf("@");
						break;
					case 40:
						printf("+");
						break;
					case 41:
						printf("-");
						break;
					case 42:
						printf("&");
						break;
					case 43:
						printf("<");
						break;
					case 44:
						printf("!");
						break;
					case 45:
						printf("=");
						break;
					case 46:
						printf("a");
						break;
					case 47:
						printf("b");
						break;
					case 48:
						printf("c");
						break;
					case 49:
						printf("d");
						break;
					case 50:
						printf("e");
						break;
					case 51:
						printf("f");
						break;
					case 52:
						printf("g");
						break;
					case 53:
						printf("h");
						break;
					case 54:
						printf("i");
						break;
					case 55:
						printf("j");
						break;
					case 56:
						printf("k");
						break;
					case 57:
						printf("l");
						break;
					case 58:
						printf("m");
						break;
					case 59:
						printf("n");
						break;
					case 60:
						printf("p");
						break;
					case 61:
						printf("q");
						break;
					case 62:
						printf("r");
						break;
					case 63:
						printf("s");
						break;
					case 64:
						printf("t");
						break;
					case 65:
						printf("u");
						break;
					case 66:
						printf("v");
						break;
					case 67:
						printf("w");
						break;
					case 68:
						printf("x");
						break;
					case 69:
						printf("y");
						break;
					case 70:
						printf("z");
						break;
					default:
						printf("?");
						break;
				}
				if(nodes[j][i].NID == nodes[j][i].CH_NID)
				{
					printf(".");	
				}
				else
					printf(" ");
			}		
		}
		printf("\n");
	}
*/
/*	        for (i = 0; i < NODESY ; i++)		
	 	{				     
	     		for(j = 0 ; j < NODESX ; j++)
			{
				if((nodes[j][i].NID == nodes[j][i].CH_NID) && (nodes[j][i].NID != 0))
				{
					for( k = 0; k < nodes[j][i].no_routing_entries; k++)
						printf("NID:%d Nei_NID:%d Valid: %d\n", nodes[j][i].NID, nodes[j][i].routing_table[k].nei_NID, nodes[j][i].routing_table[k].valid);
				}
			}
		}
*/			
//---------------------------------------------------------------------------
}


/*------------------------------------------------------------------------------*
 * Follwing function calculates the Maximum Achievable Circularity (MAC) for    *
 * each cluster & print circularity to the circularity.txt file                 *
 * This functions works only up to 1-hop clusters. Can be extened to 4-hops by  *
 * adding appropriate codes                                                     *
 *------------------------------------------------------------------------------*/
void calculate_circularity()
{
	int i, j, x0, y0, minx, miny, maxx, maxy, l, k, retvalue;
	float length, in_cluster, outof_cluster, circularity;
	int nb_list[3][500];
	int level0, level1, level2, n, m, p, q;
	
      	FILE *circlefd;
        circlefd = fopen(CIRCLEFILE, "w");
	
        for (i = 0; i < NODESX ; i++)	      
	{
		for(j = 0 ; j < NODESY ; j++)
		{
			//Make sure that the node is a CH
			if((nodes[i][j].NID == nodes[i][j].CH_NID) && (nodes[i][j].NID != 0))
			{
				in_cluster = 0;				//No of nodes in side cluster
				outof_cluster = 0;			//No of nodes out side cluster
				level0 = level1 = level2 = 0;	//Check the hope for hop-head & multi-hop clustering
      			
				x0 = (nodes[i][j].NID - 1) % NODESX;
				y0 = (nodes[i][j].NID - 1) / NODESX;

				minx = x0 - (R/GRIDX);          // 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
			        if (minx < 0)                           // Stay within the grid
	                		minx = 0;
			        maxx = x0 + (R/GRIDX);
			        if(maxx >= NODESX)
	                		maxx = NODESX -1;

			        miny = y0 - (R/GRIDY);             // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
			        if (miny < 0)                              // Stay within the grid
	                		miny = 0;
				maxy = y0 + (R/GRIDY);
			        if(maxy >= NODESY)
	                		maxy = NODESY - 1;
	
        			for(l = miny; l <= maxy; l++)		
				{
					for (k = minx; k <= maxx; k++)
					{
						length = sqrt((k - x0)*(k-x0)*(GRIDX * GRIDX) + (l - y0)*(l-y0)*(GRIDY * GRIDY));
						if((length <=  R) && (nodes[k][l].NID != 0))     // If within communication range
						{					
							if(nodes[k][l].CID == nodes[i][j].CID)
								in_cluster++;
							else
								outof_cluster++;
							nb_list[0][level0] = nodes[k][l].NID;
							level0++;		
						}
					}
				}
				if( (TTL > 1) && (level0 != 0))
				{
					for(n=0; n < level0 ; n++)
					{
						x0 = (nb_list[0][n] - 1) % NODESX;
						y0 = (nb_list[0][n] - 1) / NODESX;
						
						minx = x0 - (R/GRIDX);  
						if (minx < 0)                           // Stay within the grid
							minx = 0;
						maxx = x0 + (R/GRIDX);
				 		if(maxx >= NODESX)
		   					maxx = NODESX -1;
												                                
						miny = y0 - (R/GRIDY);  
						if (miny < 0)                          // Stay within the grid
							miny = 0;
						maxy = y0 + (R/GRIDY);
						if(maxy >= NODESY)
							maxy = NODESY - 1;																				
		        			for(l = miny; l <= maxy; l++)
						{
							for (k = minx; k <= maxx; k++)
							{
								length = sqrt((k-x0)*(k-x0)*(GRIDX * GRIDX) + (l-y0)*(l-y0)*(GRIDY * GRIDY));
								if((length <=  R) && (nodes[k][l].NID != 0))  
								{
									for(m = 0; m < level0; m++)
									{
										if(nb_list[0][m] == nodes[k][l].NID)
											break;
									}
									for( p = 0; p < level1; p++)
									{
										if(nb_list[1][p] == nodes[k][l].NID)
											break;
									}
									if((m == level0) && (p == level1))
									{
										if(nodes[k][l].CID == nodes[i][j].CID)
											in_cluster++;
										else
											outof_cluster++;
										nb_list[1][level1] = nodes[k][l].NID;
										level1++;		
									}
								}
							}
						}
					}
				}
				if( (TTL > 2) && (level1 != 0))
                                {
                                        for(n=0; n < level1 ; n++)
                                        {
                                                x0 = (nb_list[1][n] - 1) % NODESX;
                                                y0 = (nb_list[1][n] - 1) / NODESX;

                                                minx = x0 - (R/GRIDX);
                                                if (minx < 0)                           // Stay within the grid
                                                        minx = 0;
                                                maxx = x0 + (R/GRIDX);
                                                if(maxx >= NODESX)
                                                        maxx = NODESX -1;

                                                miny = y0 - (R/GRIDY);
                                                if (miny < 0)                          // Stay within the grid
                                                        miny = 0;
                                                maxy = y0 + (R/GRIDY);
                                                if(maxy >= NODESY)
                                                        maxy = NODESY - 1;

						for(l = miny; l <= maxy; l++)
                                                {
                                                        for (k = minx; k <= maxx; k++)
                                                        {
                                                                length = sqrt((k-x0)*(k-x0)*(GRIDX * GRIDX) + (l-y0)*(l-y0)*(GRIDY * GRIDY));
                                                                if((length <=  R) && (nodes[k][l].NID != 0))
                                                                {
                                                                        for(m = 0; m < level0; m++)
                                                                        {
                                                                                if(nb_list[0][m] == nodes[k][l].NID)
                                                                                        break;
                                                                        }
                                                                        for( p = 0; p < level1; p++)
                                                                        {
                                                                                if(nb_list[1][p] == nodes[k][l].NID)
                                                                                        break;
                                                                        }
                                                                        for(q= 0; q < level2; q++)
                                                                        {
                                                                                if(nb_list[2][q] == nodes[k][l].NID)
                                                                                        break;
                                                                        }

                                                                        if((m == level0) && (p == level1) && (q == level2))
                                                                        {
                                                                                if(nodes[k][l].CID == nodes[i][j].CID)
                                                                                        in_cluster++;
                                                                                else
                                                                                        outof_cluster++;
                                                                                nb_list[2][level2] = nodes[k][l].NID;
                                                                                level2++;
                                                                        }
                                                                }
                                                        }
                                                }

                                        }

                                }

				circularity = (in_cluster/(in_cluster + outof_cluster)) * 100;
				retvalue = sprintf(msg, "%f\n", circularity);
				fputs(msg, circlefd);
			}
		}
	}		
	fclose(circlefd);	//Close file
}

