#define GRIDX		10		//Unit in x direction
#define GRIDY		10		//Unit in y direction
#define R		20		//Communication radious of a node
#define CH_CH_R_FACT	3		//CH-to-CH communication range as a factor of node-to-node communication range
#define TTL		1		//Max no of hops to propagate the message
#define NODESX		101		//No of nodes in X axis
#define NODESY		101		//No of nodes in y axis.         Total no of nodes = NODESX * NODESY
#define MAXROUTES 	20		//Maximum no of routing entries 

#define STARTX	50		//x value of the starting node
#define STARTY	50		//y value of the starting node

#define NODEPROB	2	//Node probability 1/x

#define CLUSTER_DELAY	1	//Cluster formation delay. 1 time unit

#define DATA_PACKET_SIZE  	1600            // Data Packet size in bits
#define CLUSTER_BCAST_SIZE	160		// Cluster Formation Size in bits

#define NODEFILE        "nodes.txt"
#define CIRCLEFILE	"circular.txt"
#define	NODELIST	"input_nodes.txt"
#define	ENERGYFILE	"energy.txt"		//Store energy status after cluster formation

typedef struct {
	unsigned int id[2];
} Hie_CID;

typedef struct {				//Neighbor status
	unsigned char hops;
	unsigned char low_energy;		//if 1 node is low in energy
	unsigned char parent;			//Entry learn from parent CH
	unsigned char child;			//Entry learn from child CH
	unsigned char neigh;			//Entry lean from neighbor
	int nei_NID;
} nei_status;

typedef struct {
	unsigned char valid;	//Valid indicate the status of the routing entry. Status is indicated by follwoing combination of bits
				// Low in Energy|Learn from neighbor| Route to Parent CH |Valid Route
				// bit is 0 is not set. Is 1 if set.
       				// Valid = 0 (0000)- Route is not valid
				// Valid = 1 (0001)- Router is valid
				// Valid = 3 (0011)- Route is valid & towards the parent CH
				// Valid = 5 (0101)- Router is valid & lean from neighbor
				// Valid = 9 (1001)- Router is valid but should be avoided whenever possible
				// Valid = 13(1101) -Router is valid but should be avoided whenever possible  
				// Valid = 11 (1011)- Router is valid & to the parent CH. But should be avoided whenever possible
				// Valid = 2 (010), 4 (100), 6 (101), 7 (111), 8 (1000), 10 (1010), 12 (1100), 14 (1110), 15 (1111)- these
				//  status can't exist 
	Hie_CID nei_H_CID;	//Neighbor Hierarchical CID
	int nei_NID;		//Neighbors NID
} router_entry;

typedef struct {
	int NID;
	int CID;
	Hie_CID H_CID;
	int broadcasts;
	int CH_NID;
	int parent_CH_NID;		//This will be used only if node is a CH
	int no_child_nodes;
	int tree_depth;
	int last_bcast_for;
	unsigned char no_routing_entries;
	router_entry routing_table[MAXROUTES];
	float energy;
	int no_msg_forward ;
	unsigned char send_inform_neighbor;
	unsigned char send_energy_low_msg;	//Will be 1 if energy low message is already send
	unsigned char node_dead;		//Will be 1 if node is dead
} node;

typedef struct EVENT{
	struct EVENT	*next;
	int time;
	int NID;
	int CID;
	Hie_CID H_CID;
	int depth;
	int ttl;
	int parent_CID;
	Hie_CID parent_H_CID;
	int parent_CH_NID;
} event;

typedef struct {
	int source_NID;
	Hie_CID source_H_CID;
	int dest_NID;
	Hie_CID dest_H_CID;
} packet;

void init();
void add_to_event_list(int start_time, int NID, int CID, Hie_CID H_CID,  int depth, int ttl, int parent_CID, int parent_CH_NID, Hie_CID parent_H_CID);
void remove_from_event_list(int start_time);
void process_event_list();
void print_nodes();
void add_nodes_to_cluster(int nid, int CID, int CH_NID, int depth, int hops, int ttl);
void select_child_CHs(int depth, int parent_CID, Hie_CID parent_H_CID, int parent_CH_NID);
void calculate_circularity();
Hie_CID generate_CID(Hie_CID parent_ID, int child_no, int depth);
int next_hop(Hie_CID dest_add, int current_NID, int sender_NID);
void test_routing();
unsigned char send_data();
void inform_neighbors(int NID, int range);
void inform_energy_low(int NID, int range);
void print_cluster_energy();
float residual_energy(int x, int y);
void bubble_sort(nei_status *neigh, int n);


int no_new_nodes[30]	= {6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}; 
int delay[30][3]	= { 	{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0},
				{0, 0, 0}	};
