/*------------------------------------------------------------------------------*
 * Version - 6.0                                                                *
 * BY - Dilum Bandara                                                           *
 * Type - HHC - Breadth First tree formation & hierarchical naming              *
 *------------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "simulator.h"
#include "energy.h"

node nodes[NODESX][NODESY];			//Hold the node information	
event *root;					//Root of the event list
int candidateCHs[625];         			//Hold the candidate CHs
int no_candidate_CHs = 0;       
char msg[100];
int nextCID = 1;
int current_time  = 0;
int last_event_time = 0;
packet data_packet;

int main()
{
	init();					//initialize nodes & link list
	while(1)				//Process the event list until no events are found
	{
		process_event_list();
	}
}

/*------------------------------------------------------------------------------*
 * Initialise the nodes & event list                                            *
 * Nodes may either randomly genrated or use from the pregenerated file         *
 *------------------------------------------------------------------------------*/
void init()
{
	int no_nodes_to_generate;			//No of nodes to generate
	int count, x, y, i, j, start_nid, nid;
	FILE *nodes_fd;
	char str[10];
	Hie_CID root_H_CID;
	
	count = 0;
	srand(time(NULL));                              //Set the seed for rand()
	
	//Set all the nodes to 0
	for (i = 0; i < NODESX ; i++)
	{
		for(j = 0 ; j < NODESY ; j++)
		{
			nodes[i][j].CID = 0;                    // Initially set all nodes to 0
			nodes[i][j].NID = 0;                    // Set NIDs from left to right. Set nos from 1
			nodes[i][j].broadcasts = 0;
			nodes[i][j].CH_NID = 0;
			nodes[i][j].parent_CH_NID = 0;
			nodes[i][j].no_child_nodes = 0;
			nodes[i][j].no_routing_entries = 0;
			nodes[i][j].no_msg_forward = 0;
			nodes[i][j].send_energy_low_msg = 0;
			nodes[i][j].send_inform_neighbor = 0;
			nodes[i][j].node_dead = 0;
		}
	}
	
	
	//Set the given no of nodes	
	//no_nodes_to_generate = (NODESX * NODESY) /  NODEPROB;
	no_nodes_to_generate = 3922;

//Enable following code segment if nodes are to be generated randomly
//---------------------------------------------------------------------
/*
	while (1)
	{
		x = rand() % NODESX;
		y = rand() % NODESY;
		if(nodes[x][y].NID == 0)
		{		
			nodes[x][y].NID = y * NODESX + x + 1;   // Set NIDs from left to right. Set nos from 1
			count++;
			nodes[x][y].energy = E_NODE;		//Set the node's initial energy
		}
		if(count == no_nodes_to_generate)
			break;
	}

        if(nodes[STARTX][STARTY].NID == 0)	//See whether the starting node exist
	{
		printf("Can't continue. Intial node doesn't exist\n");
		exit(1);
	}
*/
//----------------------------------------------------------------------

//Enable follwoing code block if previously generated node file to be used
//----------------------------------------------------------------------	

	nodes_fd = fopen(NODELIST, "r");
	if(nodes_fd == NULL)
	{
		perror("ERROR:");
		exit(1);
	}
	
	for(i = 0; i < 	no_nodes_to_generate; i++)
	{
		fgets(str, 10, nodes_fd);
		nid = atoi(str);
		x = (nid - 1) % NODESX;
		y = (nid - 1) / NODESX;
		nodes[x][y].NID = y * NODESX + x + 1;   // Set NIDs from left to right. Set nos from 1
		nodes[x][y].energy = E_NODE;		//Set the nodes initial energy
	}
	fclose(nodes_fd);

//-------------------------------------------------------------------------------

	root = (event *)malloc(sizeof(event));
	if(root == NULL)
	{
		perror("Error while allocating memory\n");
		exit(1);
	}
	root->next = NULL;		
	
	//Add the first event to the event list
	start_nid = STARTY * NODESX + STARTX + 1;
	root_H_CID.id[0] = 0;
	root_H_CID.id[1] = 0;
	add_to_event_list(1, start_nid, 1, root_H_CID, 0, TTL, 0, 0, root_H_CID);
	//add_to_event_list(1, start_nid, 1, root_H_CID, 0, TTL, 1, start_nid);
}

/*------------------------------------------------------------------------------*
 * Add events to event list                                                     *
 * Implementation of this function will slightly vary depending on the tree     *
 * formation approach (breadth-first, depath first, etc.)                       *
 * This implementation is for the Breadth-first                                 *
 *------------------------------------------------------------------------------*/
void add_to_event_list(int start_time, int NID, int CID, Hie_CID H_CID, int depth, int ttl, int parent_CID, int parent_CH_NID, Hie_CID parent_H_CID)
{
	event *new, *current, *previous;

	last_event_time = start_time;		//Always add as the last event
	current = root;
	previous = NULL;
	while( (current->next != NULL) && (current->time < start_time))
	{
		previous = current;
		current = current->next;
	}			
	new = (event *)malloc(sizeof(event));	
	if(new == NULL)
	{
		perror("Error while allocating memory\n");									
		exit(1);
	}
	new->time = start_time;
	new->NID = NID;
	new->CID = CID;
	new->H_CID = H_CID;
	new->depth = depth;
	new->ttl = ttl;
	new->parent_CID = parent_CID;
	new->parent_CH_NID = parent_CH_NID;
	if(parent_CH_NID != 0)
		new->parent_H_CID = parent_H_CID;
	
	if((current->next == NULL) && (current->time < start_time))
	{
		new->next = NULL;
		current->next = new;
	}
	else
	{
		new->next = current;
		previous->next = new;
	}
	if(previous == NULL)
		root->next = new;
}

/*------------------------------------------------------------------------------*
 * Remove from event list							*
 *------------------------------------------------------------------------------*/
void remove_from_event_list(int start_time)
{
	event *new, *current, *previous;

	if(root->next == NULL)
	{	
		printf("Event list is already empty\n");
		exit(1);
	}
	current = root;
	previous = NULL;
	while( (current->next != NULL) && (current->time < start_time))
	{
		previous = current;
		current = current->next;
	}
	if(current->next == NULL)
	{
		free(current);
		previous->next = NULL;
	}
	else
	{
		previous->next = current->next;
		free(current);
	}
}

/*------------------------------------------------------------------------------*
 * Process the event list starting from the first event				*
 *------------------------------------------------------------------------------*/
void process_event_list()
{
	event *next_event, *nevent;
	int x0, y0, parentx0, parenty0, parent_NID, next_route_no;
	unsigned char result;
	unsigned int no_msg_delivered = 0;	//No of sucessfully delivered messages
	unsigned int no_msg_dropped = 0;        //Nof of messages dropped
	unsigned int no_route = 0;		//No fo routes not found
	
	if(root->next == NULL)			//If no more events to handle print the data & exit
	{

		calculate_circularity();
/*		print_cluster_energy();
		while (1)			//Loop forever
		{
			result = send_data();
			if(result == 1)
			{
				no_msg_dropped++;
				break;
			}
			else if (result == 2)
			{
				no_route++;
				break;
			}
			else
				no_msg_delivered++;
		}
		//printf("%d\n", no_msg_delivered);
		printf("%d\t%d\t%d\n", no_msg_delivered, no_msg_dropped, no_route);
		//test_routing();
*/	
		print_nodes();
		exit(0);	
	}
	else
	{		
		next_event = root->next;
		current_time = next_event->time;			//Set the current time
		x0 = (next_event->NID - 1) % NODESX;
		y0 = (next_event->NID - 1) / NODESX;
			 
		if(nodes[x0][y0].CID == 0)
		{
			nodes[x0][y0].CID = next_event->CID;		//Set the CID of the starting node		
			nodes[x0][y0].H_CID = next_event->H_CID;
			nodes[x0][y0].CH_NID = next_event->NID;		//Set me as my own CH
	       		nodes[x0][y0].tree_depth = next_event->depth;
	       		nodes[x0][y0].parent_CH_NID = next_event->parent_CH_NID;	
				 
			add_nodes_to_cluster(next_event->NID, next_event->CID, next_event->NID, next_event->depth, 1, next_event->ttl);	
			if(nodes[x0][y0].no_child_nodes == 0)
			{
		//		nodes[x0][y0].CID = next_event->parent_CID;
		//		nodes[x0][y0].CH_NID = next_event->parent_CH_NID;
	       	//		nodes[x0][y0].parent_CH_NID = 0;	
		//		nodes[x0][y0].tree_depth = (next_event->depth) - 1;
			}
			else
			{
				if(next_event->parent_CH_NID != 0)			//If not the root node
				{
					nodes[x0][y0].no_routing_entries++;
					nodes[x0][y0].routing_table[0].valid = 3;	//Valid & parent routing entry
					nodes[x0][y0].routing_table[0].nei_H_CID = next_event->parent_H_CID;	
					nodes[x0][y0].routing_table[0].nei_NID = next_event->parent_CH_NID;	

					//Add to parent routing table
					parent_NID = nodes[x0][y0].parent_CH_NID;
					parentx0 = (parent_NID - 1) % NODESX;
					parenty0 = (parent_NID - 1) / NODESX;
					next_route_no = nodes[parentx0][parenty0].no_routing_entries;
					nodes[parentx0][parenty0].routing_table[next_route_no].valid = 1;
					nodes[parentx0][parenty0].routing_table[next_route_no].nei_H_CID = next_event->H_CID;
					nodes[parentx0][parenty0].routing_table[next_route_no].nei_NID = next_event->NID;	
					nodes[parentx0][parenty0].no_routing_entries++;
					
				}
				select_child_CHs(next_event->depth, next_event->CID, next_event->H_CID, next_event->NID );
				nodes[x0][y0].energy -= energy_to_transmit(CLUSTER_BCAST_SIZE, (float)R); 
			}
		}
		remove_from_event_list(next_event->time);	
	}
}

/*------------------------------------------------------------------------------*
//Add nodes to cluster
 *------------------------------------------------------------------------------*/
void add_nodes_to_cluster(int nid, int cid, int CH_NID, int depth, int hops, int ttl)
{
	int x0, y0, minx, miny, maxx, maxy, no_of_neighbors, n, newx0, newy0, CH_x, CH_y, l, k, i;
	float length;
	int neighbors[625];					//No if 1-hop neighbors. This depends on tranmissions distance
								//So no of entries in the array (2 * r + 1)^2 -1
								//Will be valid untill communication distance is 12 time grid size
	no_of_neighbors = 0;	
	x0 = (nid - 1) % NODESX;
	y0 = (nid - 1) / NODESX;
	
	minx = x0 - (R/GRIDX) - 1;                              // 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
	if (minx < 0)                                           // Stay within the grid			
		minx = 0;
	maxx = x0 + (R/GRIDX) + 1;
	if(maxx >= NODESX)
		maxx = NODESX -1;

	miny = y0 - (R/GRIDY) - 1;                              // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
	if (miny < 0)                                           // Stay within the grid
		miny = 0;		
	maxy = y0 + (R/GRIDY) + 1;
	if(maxy >= NODESY)
		maxy = NODESY - 1;

	if(nodes[x0][x0].last_bcast_for == cid)			//Check whether the cluster formation message is already broadcasted
		return;						//If so discard
	else							//If not
	{	
		nodes[x0][y0].broadcasts++;                  	//Node is broadcastsing	
		nodes[x0][y0].last_bcast_for = cid;		//Set the CH who send the last broadcast
		//Energy consumed to transmit a message
		nodes[x0][y0].energy -= energy_to_transmit(CLUSTER_BCAST_SIZE, (float)R); 
	}

	//Set CID for only neighboring nodes   
	for(l = miny; l <= maxy; l++)
	{
		for (k = minx; k <= maxx; k++)
		{
			length = sqrt((k - x0)*(k-x0)*(GRIDX * GRIDX) + (l - y0)*(l-y0)*(GRIDY * GRIDY));
			
			// If within communication range & if the node exist
			if ((length <= R) && (nodes[k][l].NID != 0) && (length != 0))     
			{
				nodes[k][l].energy -= energy_to_receive(CLUSTER_BCAST_SIZE);	//Energy consumed to receive a message
				
				//If Hops <  2 * MaxHops + 1
				if(hops != (2 * TTL + 1))
				{
		                	if(nodes[k][l].CID == 0)		//If not already a member of a cluster
					{
						neighbors[no_of_neighbors] = nodes[k][l].NID;
						no_of_neighbors++;
					}
					
					if(hops <= TTL)
					{
					   	//If not a member of a cluster assigned to the current cluster
		 				if(nodes[k][l].CID == 0)   
						{
							nodes[k][l].CID = cid;
							nodes[k][l].CH_NID = CH_NID;
							nodes[k][l].tree_depth = depth + 1;
							CH_x = (CH_NID - 1) % NODESX;
							CH_y = (CH_NID - 1) / NODESY;
							nodes[CH_x][CH_y].no_child_nodes++;
						}
					}
				}
				else	//If H(ps = MaxHops * 2 + 1
				{
					if(nodes[k][l].CID == 0)        // If not a memeber of any cluster
					{
						//See whether it has already been seleted as a candidate to become a CH
                                                for( i = 0; i < no_candidate_CHs; i++)
						{
							if(candidateCHs[i] == nodes[k][l].NID)
								break;
						}
						if( i == no_candidate_CHs)
						{       
							candidateCHs[no_candidate_CHs] = nodes[k][l].NID;
							no_candidate_CHs++;
						}
					}	
				}
			}
		}
	}
	        
	for (n = 0; n < no_of_neighbors; n++)
	{
		newx0 = (neighbors[n] - 1) % NODESX;
		newy0 = (neighbors[n] - 1) / NODESX;
	
		//For each node find other 1-hop neighbors & keep forwarding cluster formation message
		hops++;
		depth++;
		add_nodes_to_cluster(neighbors[n], cid, CH_NID, depth, hops, ttl);
		depth--;
		hops--;
	}
}


/*------------ ---------------------------------------------------------------*
 * This function selecte candidate CHs                                        *
 *----------------------------------------------------------------------------*/
void select_child_CHs(int depth, int parent_CID, Hie_CID parent_H_CID, int parent_CH_NID)
{
	int no_new_CHs, next_CH_x, next_CH_y, next_CH, delay_next_cluster, j, l, new_time;
	int selected_CH_list[10];
	int no_selected_CHs = 0;
	int loops = 0;
	Hie_CID new_H_CID;
	
	if(no_candidate_CHs == 0)		//If no nodes are there to be elected as CHs return function
		return;	
	
	if(depth < 30)				//If no of candidate CHs are given in the header file
		no_new_CHs= no_new_nodes[depth];		
	else					//if not use the last no given in the header file
		no_new_CHs = no_new_nodes[29];

	if(no_new_CHs > no_candidate_CHs)	//If no of possible CHs are less than what is given in the header file
		no_new_CHs = no_candidate_CHs;	//Generate the maximum possible no

	for(j = 0; j < no_new_CHs; j++)			//Select given no of candidate neighbors as CHs
	{
		while(1)
		{
//			if(no_candidate_CHs == 0)			//If there are no candidate node who is not a member
//				break;
			
			next_CH = rand() % (no_candidate_CHs); 		//Randomly select one of the nodes to be the CH
//			next_CH_x = (candidateCHs[next_CH] - 1) % NODESX;
//			next_CH_y = (candidateCHs[next_CH] - 1) / NODESX;
			
/*			if(nodes[next_CH_x][next_CH_y].CID != 0)	//If the selected candidate has already been assigned as a CH
			{	
				loops++;			
				if(loops == 200);	//Just keep looping until a possble one is found or until loop count exceeds. 
							//200 is just an aribiatory value just to prevent the loop form becoming infinite
					break;		//If so break the loop
				continue;
			}
*/			
			for(l = 0 ; l < no_selected_CHs ; l++)			//Check whether it has been already selected
			{
				if(selected_CH_list[l] == candidateCHs[next_CH])	//If so don't selecte again
					break;	
			}
			if(l != no_selected_CHs)			//If so diacard & select another
				continue;
			
			selected_CH_list[no_selected_CHs] = candidateCHs[next_CH];
                        no_selected_CHs++;
				
			nextCID++;					//generate the next CID
			if(depth < 30)
				delay_next_cluster = delay[depth][j];
			else
				delay_next_cluster = delay[29][j];
			
			//Set the timeing such that tree is formed using the Breadth-first tree formation
			new_time = last_event_time + delay_next_cluster + CLUSTER_DELAY;

			//Add to the event list
			new_H_CID = generate_CID(parent_H_CID, j, ( depth + 1));
	 		add_to_event_list(new_time, candidateCHs[next_CH], nextCID, new_H_CID, (depth + 1), TTL, parent_CID, parent_CH_NID, parent_H_CID);
			break;
		}
	}
	no_candidate_CHs = 0;
}


/*------------------------------------------------------------------------------*
 * This function either printer the node status on the terminal or print node   *
 * data to a text file named nodes.txt                                          *
 * symbols:                                                                     *
 * '.' - Indicate grid points with nodes                                        *
 * 'o' - Indicate nodes with a CH                                               *
 * '?' - Indicare nodes clusters that don't have a represnetable symbol         *
 * Cluster symbol followed by a . indicate CHs                                  *
 *------------------------------------------------------------------------------*/
void print_nodes()
{
        int i, j, retvalue, k;
	FILE *nodefd;
	FILE *energyfd;
	nodefd = fopen(NODEFILE, "w");

	//Following code write node data to the text file	
	for (i = 0; i < NODESY ; i++)
	{
		for(j = 0 ; j < NODESX ; j++)
		{
			if(nodes[j][i].NID != 0)
			{
				retvalue = sprintf(msg, "%d\t%d\t%d\t%d\t%d\t%d\t%d\n", nodes[j][i].NID, nodes[j][i].CID, nodes[j][i].broadcasts, nodes[j][i].CH_NID, nodes[j][i].no_child_nodes, nodes[j][i].tree_depth, nodes[j][i].parent_CH_NID);
				fputs(msg, nodefd);
			}
		}
	}
	fclose(nodefd);
	
//Disable follwing code segment to prevent if form writing to the terminal
//---------------------------------------------------------------------------
/*
	for (i = 0; i < NODESY ; i++)
	{
		for(j = 0 ; j < NODESX ; j++)
		{
			if(nodes[j][i].NID == 0)	
				printf(". ");
			else
			{
				switch (nodes[j][i].CID )
				{
					case 0:
						printf("o");
						break;
					case 1:	
						printf("1");
						break;
					case 2:
						printf("2");
						break;
					case 3:
						printf("3");
						break;
					case 4:
						printf("4");
						break;
					case 5:
						printf("5");
						break;
					case 6:
						printf("6");
						break;
					case 7:
						printf("7");
						break;
					case 8: 
						printf("8");
						break;
					case 9:
						printf("9");
						break; 
					case 10:
						printf("A");
						break;
					case 11:
						printf("B");
						break;
					case 12:
						printf("C");
						break;
					case 13:
						printf("D");
						break;
					case 14:
						printf("E");
						break;
					case 15:
						printf("F");
						break;
					case 16:
						printf("G");
						break;
					case 17: 
						printf("H");
						break;
					case 18: 
						printf("I");
						break;
					case 19:
						printf("J");
						break;
					case 20: 
						printf("K");
						break;
					case 21: 
						printf("L");
						break;
					case 22: 
						printf("M");
						break;
					case 23:
						printf("N");
						break;
					case 24:
						printf("O");
						break;
					case 25:
						printf("P");
						break;
					case 26:
						printf("Q");
						break;
					case 27:
						printf("R");
						break;
					case 28:
						printf("S");
						break;	
					case 29:
						printf("T");
						break;
					case 30:
						printf("U");
						break;
					case 31:
						printf("V");
						break;
					case 32:
						printf("W");
						break;
					case 33:
						printf("X");
						break;
					case 34:	
						printf("Y");
						break;
					case 35: 
						printf("Z");
						break;
					case 36:
						printf("*");
						break;
					case 37:
						printf("#");
						break;
					case 38:
						printf("$");
						break;
					case 39:
						printf("@");
						break;
					case 40:
						printf("+");
						break;
					case 41:
						printf("-");
						break;
					case 42:
						printf("&");
						break;
					case 43:
						printf("<");
						break;
					case 44:
						printf("!");
						break;
					case 45:
						printf("=");
						break;
					case 46:
						printf("a");
						break;
					case 47:
						printf("b");
						break;
					case 48:
						printf("c");
						break;
					case 49:
						printf("d");
						break;
					case 50:
						printf("e");
						break;
					case 51:
						printf("f");
						break;
					case 52:
						printf("g");
						break;
					case 53:
						printf("h");
						break;
					case 54:
						printf("i");
						break;
					case 55:
						printf("j");
						break;
					case 56:
						printf("k");
						break;
					case 57:
						printf("l");
						break;
					case 58:
						printf("m");
						break;
					case 59:
						printf("n");
						break;
					case 60:
						printf("p");
						break;
					case 61:
						printf("q");
						break;
					case 62:
						printf("r");
						break;
					case 63:
						printf("s");
						break;
					case 64:
						printf("t");
						break;
					case 65:
						printf("u");
						break;
					case 66:
						printf("v");
						break;
					case 67:
						printf("w");
						break;
					case 68:
						printf("x");
						break;
					case 69:
						printf("y");
						break;
					case 70:
						printf("z");
						break;
					default:
						printf("?");
						break;
				}
				if(nodes[j][i].NID == nodes[j][i].CH_NID)
				{
					printf(".");	
				}
				else
					printf(" ");
			}		
		}
		printf("\n");
	}
*/
/*	        for (i = 0; i < NODESY ; i++)		
	 	{				     
	     		for(j = 0 ; j < NODESX ; j++)
			{
				if((nodes[j][i].NID == nodes[j][i].CH_NID) && (nodes[j][i].NID != 0))
				{
					for( k = 0; k < nodes[j][i].no_routing_entries; k++)
						printf("NID:%d Nei_NID:%d Valid: %d\n", nodes[j][i].NID, nodes[j][i].routing_table[k].nei_NID, nodes[j][i].routing_table[k].valid);
				}
			}
		}
*/			
//---------------------------------------------------------------------------
}


/*------------------------------------------------------------------------------*
 * Follwing function calculates the Maximum Achievable Circularity (MAC) for    *
 * each cluster & print circularity to the circularity.txt file                 *
 * This functions works only up to 1-hop clusters. Can be extened to 4-hops by  *
 * adding appropriate codes                                                     *
 *------------------------------------------------------------------------------*/
void calculate_circularity()
{
	int i, j, x0, y0, minx, miny, maxx, maxy, l, k, retvalue;
	float length, in_cluster, outof_cluster, circularity;
	int nb_list[3][500];
	int level0, level1, level2, n, m, p, q;
	
      	FILE *circlefd;
        circlefd = fopen(CIRCLEFILE, "w");
	
        for (i = 0; i < NODESX ; i++)	      
	{
		for(j = 0 ; j < NODESY ; j++)
		{
			//Make sure that the node is a CH
			if((nodes[i][j].NID == nodes[i][j].CH_NID) && (nodes[i][j].NID != 0))
			{
				in_cluster = 0;				//No of nodes in side cluster
				outof_cluster = 0;			//No of nodes out side cluster
				level0 = level1 = level2 = 0;	//Check the hope for hop-head & multi-hop clustering
      			
				x0 = (nodes[i][j].NID - 1) % NODESX;
				y0 = (nodes[i][j].NID - 1) / NODESX;

				minx = x0 - (R/GRIDX);          // 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
			        if (minx < 0)                           // Stay within the grid
	                		minx = 0;
			        maxx = x0 + (R/GRIDX);
			        if(maxx >= NODESX)
	                		maxx = NODESX -1;

			        miny = y0 - (R/GRIDY);             // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
			        if (miny < 0)                              // Stay within the grid
	                		miny = 0;
				maxy = y0 + (R/GRIDY);
			        if(maxy >= NODESY)
	                		maxy = NODESY - 1;
	
        			for(l = miny; l <= maxy; l++)		
				{
					for (k = minx; k <= maxx; k++)
					{
						length = sqrt((k - x0)*(k-x0)*(GRIDX * GRIDX) + (l - y0)*(l-y0)*(GRIDY * GRIDY));
						if((length <=  R) && (nodes[k][l].NID != 0))     // If within communication range
						{					
							if(nodes[k][l].CID == nodes[i][j].CID)
								in_cluster++;
							else
								outof_cluster++;
							nb_list[0][level0] = nodes[k][l].NID;
							level0++;		
						}
					}
				}
				if( (TTL > 1) && (level0 != 0))
				{
					for(n=0; n < level0 ; n++)
					{
						x0 = (nb_list[0][n] - 1) % NODESX;
						y0 = (nb_list[0][n] - 1) / NODESX;
						
						minx = x0 - (R/GRIDX);  
						if (minx < 0)                           // Stay within the grid
							minx = 0;
						maxx = x0 + (R/GRIDX);
				 		if(maxx >= NODESX)
		   					maxx = NODESX -1;
												                                
						miny = y0 - (R/GRIDY);  
						if (miny < 0)                          // Stay within the grid
							miny = 0;
						maxy = y0 + (R/GRIDY);
						if(maxy >= NODESY)
							maxy = NODESY - 1;																				
		        			for(l = miny; l <= maxy; l++)
						{
							for (k = minx; k <= maxx; k++)
							{
								length = sqrt((k-x0)*(k-x0)*(GRIDX * GRIDX) + (l-y0)*(l-y0)*(GRIDY * GRIDY));
								if((length <=  R) && (nodes[k][l].NID != 0))  
								{
									for(m = 0; m < level0; m++)
									{
										if(nb_list[0][m] == nodes[k][l].NID)
											break;
									}
									for( p = 0; p < level1; p++)
									{
										if(nb_list[1][p] == nodes[k][l].NID)
											break;
									}
									if((m == level0) && (p == level1))
									{
										if(nodes[k][l].CID == nodes[i][j].CID)
											in_cluster++;
										else
											outof_cluster++;
										nb_list[1][level1] = nodes[k][l].NID;
										level1++;		
									}
								}
							}
						}
					}
				}
				if( (TTL > 2) && (level1 != 0))
                                {
                                        for(n=0; n < level1 ; n++)
                                        {
                                                x0 = (nb_list[1][n] - 1) % NODESX;
                                                y0 = (nb_list[1][n] - 1) / NODESX;

                                                minx = x0 - (R/GRIDX);
                                                if (minx < 0)                           // Stay within the grid
                                                        minx = 0;
                                                maxx = x0 + (R/GRIDX);
                                                if(maxx >= NODESX)
                                                        maxx = NODESX -1;

                                                miny = y0 - (R/GRIDY);
                                                if (miny < 0)                          // Stay within the grid
                                                        miny = 0;
                                                maxy = y0 + (R/GRIDY);
                                                if(maxy >= NODESY)
                                                        maxy = NODESY - 1;

						for(l = miny; l <= maxy; l++)
                                                {
                                                        for (k = minx; k <= maxx; k++)
                                                        {
                                                                length = sqrt((k-x0)*(k-x0)*(GRIDX * GRIDX) + (l-y0)*(l-y0)*(GRIDY * GRIDY));
                                                                if((length <=  R) && (nodes[k][l].NID != 0))
                                                                {
                                                                        for(m = 0; m < level0; m++)
                                                                        {
                                                                                if(nb_list[0][m] == nodes[k][l].NID)
                                                                                        break;
                                                                        }
                                                                        for( p = 0; p < level1; p++)
                                                                        {
                                                                                if(nb_list[1][p] == nodes[k][l].NID)
                                                                                        break;
                                                                        }
                                                                        for(q= 0; q < level2; q++)
                                                                        {
                                                                                if(nb_list[2][q] == nodes[k][l].NID)
                                                                                        break;
                                                                        }

                                                                        if((m == level0) && (p == level1) && (q == level2))
                                                                        {
                                                                                if(nodes[k][l].CID == nodes[i][j].CID)
                                                                                        in_cluster++;
                                                                                else
                                                                                        outof_cluster++;
                                                                                nb_list[2][level2] = nodes[k][l].NID;
                                                                                level2++;
                                                                        }
                                                                }
                                                        }
                                                }

                                        }

                                }

				circularity = (in_cluster/(in_cluster + outof_cluster)) * 100;
				retvalue = sprintf(msg, "%f\n", circularity);
				fputs(msg, circlefd);
			}
		}
	}		
	fclose(circlefd);	//Close file
}

/*------------------------------------------------------------------------------*
 * Following function generates the hierarchical cluster ID based on the parent	*
 * cluster ID & node depth. CIDs are represented in the following manner	*
 *     +------------------------+----+------------------+			*
 *     |  ......|Child2|Child1|Parent|  Depth (5- bits)	|			*
 *     +------------------------+----+------------------+			*
 *     Depth - 5 bits - Can represent upto depth of 32 levels in the tree 	*
 *     Branching factor (B) - up to 8 bracnhes (3 bits to represent each brancg	*
 *     number. 									*
 *     Child ID = Parent ID + (Branch No << ((Depth -1) * B)+ 5) + Depth 	*
 *     With 64-bit CID up to 19 level cluster tree can be represented		*
 *     However there are no 64-bit integer data structures. So an array of two	*
 *     32-bit integers are used.						*  
 *------------------------------------------------------------------------------*/
Hie_CID generate_CID(Hie_CID parent_ID, int child_no, int depth)
{
	int tmp_id0, tmp_id1, tmp_parent_ID[2], tmp_depth;
	Hie_CID new_H_CID;
	
	tmp_parent_ID[0] = parent_ID.id[0];
	tmp_parent_ID[1] = parent_ID.id[1];
	
	tmp_depth = tmp_parent_ID[1] & 31;			//Extract the depth 31 = 11111 in binary
	if ((tmp_depth + 1) != depth)				//If child depth != parent depth + 1
	{
		printf("Child depth should be equal to parent depth + 1\n");
		exit(0);
	}
	
	if(depth <= 9)					//up to depth of 9 can be represented by 32-bits (3 * 9 + 5)
	{
		tmp_id1 = child_no;
		tmp_id1 = tmp_id1 << (((depth -1) * 3) + 5); 
		tmp_id1 += tmp_parent_ID[1];
		tmp_id1++;				//Increment depth by 1 
		tmp_id0 = 0;				//The the last (MSB) 32-bits zero
	}
	else						//If not
	{
		tmp_id1 = tmp_parent_ID[1];
		tmp_id1++;				//Increment depth
		tmp_id0 = child_no;			//Move to the other part of the CID and set it
		tmp_id0 = tmp_id0 << ((depth - 10) * 3);//Shift the new no
		tmp_id0 += tmp_parent_ID[0];		//Add the MSB part of parent
	}
	new_H_CID.id[0] = tmp_id0;
	new_H_CID.id[1] = tmp_id1;
	return new_H_CID;					//Return new CID
}


/*------------------------------------------------------------------------------*
 * Follwoing function returns the NID of the next hop to forward the message	*
 * If it is for the current clusters same NID is returned			*
 * If its for a neighboring cluster its NID is returned				*
 * Otherwice the NID of the next hop is returned based on the entries in the 	*
 * routing table. 								*
 * If no suitable next hop can't be found 0 is returned				*
 *------------------------------------------------------------------------------*/
int next_hop(Hie_CID dest_add, int current_NID, int sender_NID)
{
	int x0, y0, current_depth, dest_depth, min_depth, i, j, tmp_current_add, tmp_dest_add;
	nei_status  neighbors[MAXROUTES];			//Hold the hop count for each router table entry
	int no_routing_entries;		
			
	i = 0;
	x0 = (current_NID - 1) % NODESX;
	y0 = (current_NID - 1) / NODESX;
	
	//Check whether the destination is my address
	if((nodes[x0][y0].H_CID.id[0] == dest_add.id[0]) && (nodes[x0][y0].H_CID.id[1] == dest_add.id[1]))
		return current_NID;
	
	no_routing_entries = nodes[x0][y0].no_routing_entries;
	for(j = 0; j < no_routing_entries; j++)
	{
		if((nodes[x0][y0].routing_table[j].valid & 1) == 0) 	//If route is invalid discard. Validity is indicated by 1st bit
		{
			neighbors[j].hops = 255;			//Set as unreachable	
			continue;
		}
		
		//Check whether the destination is the neighbors address
		if((nodes[x0][y0].routing_table[j].nei_H_CID.id[0] == dest_add.id[0]) && (nodes[x0][y0].routing_table[j].nei_H_CID.id[1] == dest_add.id[1]))
			return nodes[x0][y0].routing_table[j].nei_NID;
		
		current_depth = nodes[x0][y0].routing_table[j].nei_H_CID.id[1] & 31;		//31 = 11111 in binary
		dest_depth = dest_add.id[1] & 31;
		
		if((current_depth > 19) || (dest_depth > 19))		//If depth > 19 Hierarchical Address will overflow
			return 0;

		if(current_depth > dest_depth)				//Find minimum depth 
			min_depth = dest_depth;
		else
			min_depth = current_depth;
		
		for(i = 0; i < min_depth ; i++)
		{
			if(i < 9)					//Check only the first 32-bits of the address
			{	
				tmp_current_add = (nodes[x0][y0].routing_table[j].nei_H_CID.id[1] >> (5 + i * 3));	//Remove the depth info from address 
				tmp_dest_add = (dest_add.id[1] >> (5 + i * 3));
				tmp_current_add = tmp_current_add & 7;	// 7 = 111 in binary. Extract only the branch no for level i+1
				tmp_dest_add = tmp_dest_add & 7;
				if(tmp_current_add != tmp_dest_add)	//If a none matching branch is found	
					break;
			}
			else						//Check the remanining 32-bits
			{
				tmp_current_add = (nodes[x0][y0].routing_table[j].nei_H_CID.id[0] >> ((i - 9) * 3));	//Remove the depth info from address 
				tmp_dest_add = (dest_add.id[0] >> ((i - 9) * 3));
				tmp_current_add = tmp_current_add & 7;	// 7 = 111 in binary. Extract only the branch no for level i+1
				tmp_dest_add = tmp_dest_add & 7;	
				if(tmp_current_add != tmp_dest_add)	//If a none matching branch is found	
					break;
				
			}
		}
		neighbors[j].hops = (current_depth - i) + (dest_depth - i) + 1;	//add the hops up to the common branching point. 
									//+1 because therese are neighbors & 1-hop is need to reach it

		neighbors[j].nei_NID = nodes[x0][y0].routing_table[j].nei_NID;

		if((nodes[x0][y0].routing_table[j].valid & 8) == 8) 	//If energy low
			neighbors[j].low_energy = 1;
		else
			neighbors[j].low_energy = 0;

		if((nodes[x0][y0].routing_table[j].valid & 2) == 2) 	//If route is learned from parent CH
		{
			neighbors[j].parent = 1;
			neighbors[j].child = 0;
			neighbors[j].neigh = 0;					
		}
		else if((nodes[x0][y0].routing_table[j].valid & 4) == 4) 	//If route is learned from neighbor CH
		{
			neighbors[j].neigh = 1;					
			neighbors[j].child = 0;
			neighbors[j].parent = 0;
		}
		else							//If learn from child CH
		{
			neighbors[j].child = 1;
			neighbors[j].neigh = 0;					
			neighbors[j].parent = 0;
		}
	}

	bubble_sort(neighbors, no_routing_entries);			// Sort based on hop count
     
	if(neighbors[0].hops == 255)
		return 0;						//No matching next hop found
	else if ((neighbors[0].low_energy == 1) && (neighbors[0].neigh == 1))	//if the best next hop is energy constrained is a neighbor node
	{
		for(j = 1 ; j < no_routing_entries; j++)		//Find a node which is not energy constrained 
		{
			if((neighbors[j].low_energy != 1) && (neighbors[j].hops != 255) && (neighbors[j].nei_NID != sender_NID)) //If found stop
				return neighbors[j].nei_NID;
		}
	}
	//if the best next hop is energy constrained & is a parent or child CH
	else if ((neighbors[0].low_energy == 1) && ((neighbors[0].parent == 1) || (neighbors[0].child == 1)))	
	{
		for(j = 1 ; j < no_routing_entries; j++)		//Find a node which is not energy constrained 
		{
			//Find a node with enough energy & neigher a child or parent CH on the same branch of the tree
			if((neighbors[j].low_energy != 1) && (neighbors[j].hops != 255) && (neighbors[j].parent != 1) && (neighbors[j].child != 1) && (neighbors[j].nei_NID != sender_NID))
				return neighbors[j].nei_NID;
		}
	}		
	else	//If the 1st node is not energy constrained 
	{
		if (neighbors[0].nei_NID != sender_NID)		//If next hop is not same as the send of the message allow that
			return neighbors[0].nei_NID;
		else
		{						//If not pick the next best node
			for(j = 1 ; j < no_routing_entries; j++)                //Find a node which is not energy constrained
                	{
                        	if((neighbors[j].low_energy != 1) && (neighbors[j].hops != 255) && (neighbors[j].nei_NID != sender_NID)) //If found stop
                                	return neighbors[j].nei_NID;
                	}
		}
	}
	//printf("----------------------------------\n");
	//for(j = 0; j < no_routing_entries; j++)
	//printf("CURRENT_NID: %d\t NID:%d\t Energy: %d\t HOPS; %d\n", current_NID, neighbors[j].nei_NID, neighbors[j].low_energy, neighbors[j].hops);	
	
	if (neighbors[0].nei_NID != sender_NID)         //If next hop is not same as the send of the message allow that
		return neighbors[0].nei_NID;		//if there is no other suitable node just pick the 1st one given that it is not the sender
	else
	{
		for(j = 1 ; j < no_routing_entries; j++)                //Find a node which is not energy constrained
                {
                	if(( neighbors[j].hops != 255 ) && (neighbors[j].nei_NID != sender_NID)) //If found stop
                        	return neighbors[j].nei_NID;
		}
		if( j == no_routing_entries)		//No possible next node
			return 0;
	}
}

void test_routing()
{
	int x0, y0, tmp_node, count;
	int tmp_nodes[5];
		
	count = 0;
	while(1)
	{
    		tmp_node = rand() % 401;
    		x0 = (tmp_node - 1) % NODESX;	    
		y0 = (tmp_node - 1) / NODESX;
		if(nodes[x0][y0].NID == 0)
			continue;
		if(nodes[x0][y0].NID != nodes[x0][y0].CH_NID)
			continue;
		tmp_nodes[count] = nodes[x0][y0].NID;
		count++;
		if(count == 5)
			break;
	}
	
    	x0 = (tmp_nodes[1] - 1) % NODESX;	    
	y0 = (tmp_nodes[1] - 1) / NODESX;
/*
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[0], tmp_nodes[1], next_hop(nodes[x0][y0].H_CID, tmp_nodes[0]));
    	x0 = (tmp_nodes[2] - 1) % NODESX;	    
	y0 = (tmp_nodes[2] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[0], tmp_nodes[2], next_hop(nodes[x0][y0].H_CID, tmp_nodes[0]));
    	x0 = (tmp_nodes[3] - 1) % NODESX;	    
	y0 = (tmp_nodes[3] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[0], tmp_nodes[3], next_hop(nodes[x0][y0].H_CID, tmp_nodes[0]));
    	x0 = (tmp_nodes[2] - 1) % NODESX;	    
	y0 = (tmp_nodes[2] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[1], tmp_nodes[2], next_hop(nodes[x0][y0].H_CID, tmp_nodes[1]));
    	x0 = (tmp_nodes[3] - 1) % NODESX;	    
	y0 = (tmp_nodes[3] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[1], tmp_nodes[3], next_hop(nodes[x0][y0].H_CID, tmp_nodes[1]));
    	x0 = (tmp_nodes[3] - 1) % NODESX;	    
	y0 = (tmp_nodes[3] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[2], tmp_nodes[3], next_hop(nodes[x0][y0].H_CID, tmp_nodes[2]));
    	x0 = (tmp_nodes[4] - 1) % NODESX;	    
	y0 = (tmp_nodes[4] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[3], tmp_nodes[4], next_hop(nodes[x0][y0].H_CID, tmp_nodes[3]));
    	x0 = (tmp_nodes[2] - 1) % NODESX;	    
	y0 = (tmp_nodes[2] - 1) / NODESX;
	printf("Source: %d\t Dest: %d Next Hop: %d\n", tmp_nodes[4], tmp_nodes[2], next_hop(nodes[x0][y0].H_CID, tmp_nodes[4]));
*/
}

/*------------------------------------------------------------------------------*
 * Following functions randomly generate a socue and a destination node	& then	*
 * try to deliver a message between those 2 nodes. Function returns:		*
 * 0 - On sucess								*
 * 1 - when not enough energy to deliver the packet				*
 * 2 - When route to destination is not found 					*
 *------------------------------------------------------------------------------*/
unsigned char send_data()
{
        int s_x, s_y, d_x, d_y, CH_NID, source_CH_x, source_CH_y, dest_CH_x, dest_CH_y, receiver_x, receiver_y, current_x, current_y;
	int neighbor_to_forward;
	int current_NID;
	float eng;
	int msg_send_by;			//No that send the message
	
	while (1)				//Generate source node
	{
		s_x = rand() % NODESX;
		s_y = rand() % NODESY;
		if((nodes[s_x][s_y].NID == 0) ||(nodes[s_x][s_y].CID == 0))	//Make sure node is available & in a cluster
			continue;
		else if(nodes[s_x][s_y].node_dead == 1)				//Source node is dead find another node
			continue;
		else				//Form the source info of the data packet
		{
			data_packet.source_NID = nodes[s_x][s_y].NID;
			CH_NID = nodes[s_x][s_y].CH_NID;
    			source_CH_x = (CH_NID - 1) % NODESX;	    
			source_CH_y = (CH_NID - 1) / NODESX;
			data_packet.source_H_CID.id[0] = nodes[source_CH_x][source_CH_y].H_CID.id[0];
			data_packet.source_H_CID.id[1] = nodes[source_CH_x][source_CH_y].H_CID.id[1];
			break;
		}
	}	
	while (1)				//Generate destination node
	{
		d_x = rand() % NODESX;
		d_y = rand() % NODESY;
		if((nodes[d_x][d_y].NID == 0) || (nodes[d_x][d_y].CID == 0))	//Make sure node is available & a member of a cluster
			continue;
		else if((s_x == d_x) && (s_y == d_y))				//if both source & destination is equal find another
			continue; 
		else				//Form the destination info of the data packet
		{
			data_packet.dest_NID = nodes[d_x][d_y].NID;
			CH_NID = nodes[d_x][d_y].CH_NID;
    			dest_CH_x = (CH_NID - 1) % NODESX;	    
			dest_CH_y = (CH_NID - 1) / NODESX;
			data_packet.dest_H_CID.id[0] = nodes[dest_CH_x][dest_CH_y].H_CID.id[0];
			data_packet.dest_H_CID.id[1] = nodes[dest_CH_x][dest_CH_y].H_CID.id[1];
			break;
		}
	}

	if(data_packet.source_NID != nodes[s_x][s_x].CH_NID)	//If the souce is not the CH. Then forward the message to CH
	{
		nodes[s_x][s_y].energy -= energy_to_transmit(DATA_PACKET_SIZE , (float)R);	
		if(nodes[s_x][s_y].energy < 0)			//If not enough energy
		{
			nodes[s_x][s_y].node_dead = 1;		//Mark node as dead
			return 1;
		}

		if(nodes[source_CH_x][source_CH_y].node_dead == 1)		//If the rceiving CH is dead drop message
			return 1;
		
		nodes[source_CH_x][source_CH_y].energy -= energy_to_receive(DATA_PACKET_SIZE);
		if(nodes[source_CH_x][source_CH_y].energy < 0)			//If the receiver doesn't have enough energy to receive
		{
			nodes[source_CH_x][source_CH_y].node_dead = 1;		//Mark node as dead
			return 1;
		}
		msg_send_by = nodes[s_x][s_y].NID;
		nodes[s_x][s_y].no_msg_forward++;		//Count the no of messages forwarded
	}
	
	current_NID = nodes[s_x][s_y].CH_NID;			// Start forwarding from the CH

	//Loop until destination CH is found
	while(1)
	{
		neighbor_to_forward =  next_hop(data_packet.dest_H_CID, current_NID, msg_send_by);

		if(neighbor_to_forward == current_NID)
			break;
		else if (neighbor_to_forward == 0)
			return 2;				//No troute to destination
		else
		{	
			current_x = (current_NID - 1) % NODESX;	    
			current_y = (current_NID - 1) / NODESX;
			
			if(nodes[current_x][current_y].node_dead == 1)	//Node is dead can't forward the message
			{
				return 1;
			}

			//Reduce energy to transmit;
			nodes[current_x][current_y].energy -=  energy_to_transmit(DATA_PACKET_SIZE, (float) ( CH_CH_R_FACT * R));
			
			if(nodes[current_x][current_y].energy < 0)
			{
				nodes[current_x][current_y].node_dead = 1;           	//Mark node as dead
				return 1;						//Not enough energy
			}			     
			//If nodes energy is low & if a CH inform other CHs
			if((residual_energy(current_x, current_y) < T_ENERGY) && (nodes[current_x][current_y].energy > 0))
			{
				if(nodes[current_x][current_y].send_energy_low_msg != 1)            //If not already informed
				{
					inform_energy_low(current_NID, (CH_CH_R_FACT * R));      //Inform others
					nodes[current_x][current_y].send_energy_low_msg = 1;        //Energy low message is send
				}
			}

			if(nodes[current_x][current_y].send_inform_neighbor != 1)	//If the message has alread not being send
			{
				inform_neighbors(current_NID, (CH_CH_R_FACT * R));	//Add to neighbors routing table when transmitting
				nodes[current_x][current_y].send_inform_neighbor = 1;	//Mark as message is send
			}

			receiver_x = (neighbor_to_forward - 1) % NODESX;	    
			receiver_y = (neighbor_to_forward - 1) / NODESX;

                        if(nodes[receiver_x][receiver_y].node_dead == 1)       //Node is dead can't receive the message
                                return 1;

			//Reduce energy to receive
			nodes[receiver_x][receiver_y].energy -= energy_to_receive(DATA_PACKET_SIZE);

			if(nodes[receiver_x][receiver_y].energy < 0)	//Not enough energy
			{
				nodes[receiver_x][receiver_y].node_dead = 1;           	//Mark node as dead
				return 1;
			}
			msg_send_by = nodes[current_x][current_y].NID;
			nodes[current_x][current_y].no_msg_forward++;	//Count the no of messages forwarded
			current_NID = neighbor_to_forward ;	//Forward packet to neighbor. Neighbor becomes to current node 
		}
	}
	if(current_NID != data_packet.dest_NID)
	{
		//current node x, y values are cacluated in the previous loop
		
		if(nodes[receiver_x][receiver_y].node_dead == 1)       //Node is dead can't forward the message
                	return 1;

		nodes[receiver_x][receiver_y].energy -= energy_to_transmit(DATA_PACKET_SIZE, (float)R);	
		if(nodes[receiver_x][receiver_y].energy < 0)	//Not enough energy
		{	
			nodes[receiver_x][receiver_y].node_dead = 1;           	//Mark node as dead
			return 1; 
		}		

		nodes[d_x][d_y].energy -= energy_to_receive(DATA_PACKET_SIZE);
		if(nodes[dest_CH_x][dest_CH_y].energy < 0)	//Not enough energy
		{
			nodes[d_x][d_y].node_dead = 1;             //Mark node as dead
			return 1;
		}
		nodes[receiver_x][receiver_y].no_msg_forward++;   //Count the no of messages forwarded
	}
	return 0;	//Packet is sucessfully delivered
}


/*------------------------------------------------------------------------------*
 * Following function add the neighboring cluster information while a CH tranmit*
 * a message. If the information about neighboring cluster is already in the 	*
 * routing table it will not be added						*
 * NID - NID of the node transmitting						*
 * range - range of the transmitted message					*	 
 *------------------------------------------------------------------------------*/
void inform_neighbors(int NID, int range)
{
        int x0, y0, minx, miny, maxx, maxy, l, k, i;     
	float length;
	
	x0 = (NID - 1) % NODESX;
	y0 = (NID - 1) / NODESX;
								
	minx = x0 - (range/GRIDX) - 1;		// 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
	if (minx < 0)                           // Stay within the grid
		minx = 0;

	maxx = x0 + (range/GRIDX) + 1;
	if(maxx >= NODESX)
		maxx = NODESX -1;
	
	miny = y0 - (range/GRIDY) - 1;          // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
	if (miny < 0)                           // Stay within the grid
		miny = 0;

	maxy = y0 + (range/GRIDY) + 1;
	if(maxy >= NODESY)
		maxy = NODESY - 1;
	
        for(l = miny; l <= maxy; l++)	
      	{
		for (k = minx; k <= maxx; k++)
		{
			length = sqrt((k - x0)*(k - x0)*(GRIDX * GRIDX) + (l - y0)*(l - y0)*(GRIDY * GRIDY));
			
			// If within communication range, if node exists, if node is a CH
    			if ((length <= range) && (nodes[k][l].NID != 0) && (nodes[k][l].NID == nodes[k][l].CH_NID) && (length != 0))
			{
				for(i = 0; i < nodes[k][l].no_routing_entries; i++)	//Check whther the entry already exit
				{
					if(nodes[k][l].routing_table[i].nei_NID == NID )
						break;
					
				}
				if( i != nodes[k][l].no_routing_entries)		//if NID already in routing table skip
					continue;
				else							//Else add to the routing table
				{
					nodes[k][l].routing_table[i].nei_NID = NID;
					nodes[k][l].routing_table[i].nei_H_CID = nodes[x0][y0].H_CID;
					nodes[k][l].routing_table[i].valid = 5;		//Add as an entry learn from neighbor, 5 = 101
					nodes[k][l].no_routing_entries++;
				}
			}
		}
	}
}

/*------------------------------------------------------------------------------*
 * Following function informs neighboring CHs when its energy level is below the*
 * threshold. Neighboring nodes should add this information to their routing 	*
 * table in dicating this node should be avoided whever possible		*									
 * NID - NID of the node transmitting                                           *
 * range - range of the transmitted message                                     *
 *------------------------------------------------------------------------------*/
void inform_energy_low(int NID, int range)
{
	int x0, y0, minx, miny, maxx, maxy, l, k, i;
        float length;
	unsigned char tmp_valid ; 

        x0 = (NID - 1) % NODESX;
        y0 = (NID - 1) / NODESX;

        minx = x0 - (range/GRIDX) - 1;          // 1 hop neighbors are in the range of (X0 - R) to (X0 + R)
        if (minx < 0)                           // Stay within the grid
                minx = 0;

        maxx = x0 + (range/GRIDX) + 1;
        if(maxx >= NODESX)
                maxx = NODESX -1;

        miny = y0 - (range/GRIDY) - 1;          // 1 hope neighbors are in the range of (Y0 - R) tp (Y0 + R)
        if (miny < 0)                           // Stay within the grid
                miny = 0;

        maxy = y0 + (range/GRIDY) + 1;
        if(maxy >= NODESY)
                maxy = NODESY - 1;

        for(l = miny; l <= maxy; l++)
        {
                for (k = minx; k <= maxx; k++)
                {
                        length = sqrt((k - x0)*(k - x0)*(GRIDX * GRIDX) + (l - y0)*(l - y0)*(GRIDY * GRIDY));

                        // If within communication range, if node exists, if node is a CH
                        if ((length <= range) && (nodes[k][l].NID != 0) && (nodes[k][l].NID == nodes[k][l].CH_NID) && (length != 0)) 
			{
				for(i = 0; i < nodes[k][l].no_routing_entries; i++)     //Locate the routing entry
				{
                        		if(nodes[k][l].routing_table[i].nei_NID == NID )
					{
                        			nodes[k][l].routing_table[i].valid += 8;	//Mark as energy low 
					}
				}
			}
		}
	}
}

void print_cluster_energy()
{
        int i, j, retvalue;
	FILE *energyfd;        
	energyfd = fopen(ENERGYFILE, "w");

	//Following code write node energy to the text file
	for (i = 0; i < NODESY ; i++)
	{
		for(j = 0 ; j < NODESX ; j++)
		{
			if(nodes[j][i].NID != 0)
			{
				retvalue = sprintf(msg, "%f\n", nodes[j][i].energy);
				fputs(msg, energyfd);
			}
		}
	}
	fclose(energyfd);
}

/*------------------------------------------------------------------------------*
 * Following function calculate the residual energy of a given node		*
 *------------------------------------------------------------------------------*/
float residual_energy(int x, int y)
{
	return ((nodes[x][y].energy / E_NODE) * 100);
}

/*------------------------------------------------------------------------------*
 * Following function sort the neighbor routing entries in the increasing order	*
 * based on hop count. If 2 neighbors has the same hop count they are swapped	*
 * by tossing a coin. This prevents the same neighbor being slected again & 	*
 * again when they have the same hop count - allow load to be disteributed	*
 * neigh - pointer to the neighbor routing array				*
 * n - no of entries in the array
 *------------------------------------------------------------------------------*/
void bubble_sort(nei_status *neigh, int n)
{
	char swapped;
	int i;
	nei_status tmp;

	do
	{
		swapped = 0;
		for(i = 0; i < (n-1); i++)
		{
			if(neigh[i].hops > neigh[i+1].hops)
			{
				swapped = 1;
				tmp = neigh[i+1];
				neigh[i+1] = neigh[i];
				neigh[i] = tmp;
			}
			else if(neigh[i].hops == neigh[i+1].hops)
			{
 				if((rand() % 2) == 0 ) //Toss a coin & decide wich entry to use if 0 change if 1 keep  previous entry
                        	{
					tmp = neigh[i+1];
                                	neigh[i+1] = neigh[i];
                                	neigh[i] = tmp;
                        	}
			}
		}
	}
	while (swapped == 1);
}
