#define GRIDX	6		//Unit in x direction
#define GRIDY	6		//Unit in y direction
#define R	12		//Communication radious of a node
#define TTL	1		//Max no of hops to propagate the message
#define NODESX	100		//No of nodes in X axis
#define NODESY	100		//No of nodes in y axis.         Total no of nodes = NODESX * NODESY

#define STARTX	50		//x value of the starting node
#define STARTY	50		//y value of the starting node

#define NODEPROB	2       //Node probability 1/x

#define CLUSTER_DELAY	1	//Cluster formation delay. 1 time unit

#define NODEFILE        "nodes.txt"
#define CIRCLEFILE	"circular.txt"
#define	NODELIST	"input_nodes.txt"

typedef struct {
	int NID;
	int CID;
	int broadcasts;
	int CH_NID;
	int parent_CH_NID;
	int no_child_nodes;
	int tree_depth;
	int last_bcast_for;
} node;

typedef struct EVENT{
	struct EVENT	*next;
	int time;
	int NID;
	int CID;
	int depth;
	int ttl;
	int parent_CID;
	int parent_CH_NID;
} event;

void init();
void add_to_event_list(int start_time, int NID, int CID, int depth, int ttl, int parent_CID, int CH_NID);
void remove_from_event_list(int start_time);
void process_event_list();
void print_nodes();
void add_nodes_to_cluster(int nid, int cid, int CH_NID, int depth, int hops, int ttl);
void select_child_CHs(int depth, int parent_CID, int parent_CH_NID);
void calculate_circularity();

int no_new_nodes[30]	= {6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}; 
int delay[30][6]	= {	
				{1, 1679644, 3359261, 5038878, 6718495, 8398112},
				{2, 279964, 559900, 839836, 1119772, 1399708},
				{3, 46679, 93336, 139993, 186650, 233307},
				{4, 7794, 15571, 23348, 31125, 38902},
				{5, 1309, 2606, 3903, 5200, 6497},
				{6, 224, 441, 658, 874, 1092},
				{7, 45, 82, 119, 156, 193},
				{8, 16, 23, 30, 37, 44},
				{9, 11, 12, 13, 14, 15},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5},
				{0, 1, 2, 3, 4, 5}};
