/*Copyright 2011 Veeresh Rudrappa & Dilum Bandara

		   Licensed under the Apache License, Version 2.0 (the "License");
		   you may not use this file except in compliance with the License.
		   You may obtain a copy of the License at

		       http://www.apache.org/licenses/LICENSE-2.0

		   Unless required by applicable law or agreed to in writing, software
		   distributed under the License is distributed on an "AS IS" BASIS,
		   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		   See the License for the specific language governing permissions and
		   limitations under the License.
 */

/*** Contact Info *****
 * 
 * Veeresh Rudrappa 
 * Colorado State University
 * email: veeresh.rudrappa@colostate.edu
 * 
 * Dilum Bandara
 * Colorado State University
 * email: dilumb@engr.colostate.edu
 * 
 */


package com.project.extract;

import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Tcp;

public class NetworkInfo {

	
	private Sigar sigar;
	private Shell shell;
	
	public String IPaddr;
	public String Interface;
	public String MacAddr;
	public String NetMask;
	public String HostName;
	public String DomainName;
	public String DefGateway;
	public String PrimDns;
	public String SecDns;
	public long SegTransmitted;
	public long SegRecieved;
	
	
    public NetworkInfo() {
        
    	this.shell = new Shell();
    	this.sigar =  shell.getSigar();
    }


    public String getUsageShort() {
        return "Display network info";
    }
    void outputTcpStats() throws SigarException {
        Tcp stat = this.sigar.getTcp();

       
        SegRecieved=stat.getInSegs();
        SegTransmitted=stat.getOutSegs();
        

    }
    public void output() throws SigarException {
        NetInterfaceConfig config = this.sigar.getNetInterfaceConfig(null);
        Interface = new String(config.getName());
        IPaddr= new String(config.getAddress());
        MacAddr= new String(config.getHwaddr());
    }

}
