/*Copyright 2011 Veeresh Rudrappa & Dilum Bandara

		   Licensed under the Apache License, Version 2.0 (the "License");
		   you may not use this file except in compliance with the License.
		   You may obtain a copy of the License at

		       http://www.apache.org/licenses/LICENSE-2.0

		   Unless required by applicable law or agreed to in writing, software
		   distributed under the License is distributed on an "AS IS" BASIS,
		   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		   See the License for the specific language governing permissions and
		   limitations under the License.
 */

/*** Contact Info *****
 * 
 * Veeresh Rudrappa 
 * Colorado State University
 * email: veeresh.rudrappa@colostate.edu
 * 
 * Dilum Bandara
 * Colorado State University
 * email: dilumb@engr.colostate.edu
 * 
 */


package com.project.extract;

import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;


public class Memory{
	private Sigar sigar;
	private Shell shell;
	
	public long RamSize;
	public long MemAvail;
	public long SwapAvail;
	public double MemUsedPerc;
	public double MemFreePerc;
	public long SwapUsed;
	public long SwapFree;
	
	public Memory()
	{
		this.shell = new Shell();
		this.sigar = shell.getSigar();;
	}

    public void output() throws SigarException {
        Mem mem   = this.sigar.getMem();
        Swap swap = this.sigar.getSwap();
       
        RamSize=mem.getRam();
        MemAvail=((mem.getTotal())/1024);
        MemUsedPerc=mem.getUsedPercent();
        MemFreePerc=mem.getFreePercent();
 
        SwapAvail=swap.getTotal();
        SwapUsed=swap.getUsed();
        SwapFree=swap.getFree();
        SwapAvail =SwapAvail/(1024*1024);
        SwapUsed=SwapUsed/(1024*1024);
        SwapFree=SwapFree/(1024*1024);
     }

}
