/*Copyright 2011 Veeresh Rudrappa & Dilum Bandara

		   Licensed under the Apache License, Version 2.0 (the "License");
		   you may not use this file except in compliance with the License.
		   You may obtain a copy of the License at

		       http://www.apache.org/licenses/LICENSE-2.0

		   Unless required by applicable law or agreed to in writing, software
		   distributed under the License is distributed on an "AS IS" BASIS,
		   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		   See the License for the specific language governing permissions and
		   limitations under the License.
 */

/*** Contact Info *****
 * 
 * Veeresh Rudrappa 
 * Colorado State University
 * email: veeresh.rudrappa@colostate.edu
 * 
 * Dilum Bandara
 * Colorado State University
 * email: dilumb@engr.colostate.edu
 * 
 */
package com.project.extract;
import java.io.File;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

import org.hyperic.sigar.OperatingSystem;

class MemInfo{

	public String FsystemRoot;
	public long MaxSpace;
	public long FreeSpace;
}

public class GeneralInfo {


	public static int NumFs=0;
    public static final String DATE_FORMAT = "dd-MM-yyyy HH:mm:ss";

    public String OsArch;
    public String OsName;
    public String OsDesc;
    public String OsVersion;
    public File[] roots;
    public String DateTime;
    public String Timezone;
    public MemInfo[] Memory= new MemInfo[8];; 
    public void getOsInfo()
    {
    	OperatingSystem sys = OperatingSystem.getInstance();
    	
    	OsName = new String(sys.getName());
    	OsDesc = new String(sys.getDescription());
    	OsArch = new String(sys.getArch());
    	OsVersion = new String(sys.getVersion());
    }
    public void DateAndTime() 
    {
    	
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d, hh:mm aaa");
        DateTime= sdf.format(cal.getTime());
        TimeZone Tzone = cal.getTimeZone();
        
        Timezone = new String(Tzone.getDisplayName());
                
    }
    
    public void RuntimeProperties()
    {
    	roots = File.listRoots();
        NumFs=0;
        for (File root : roots) {
        	Memory[NumFs] = new MemInfo();
        	Memory[NumFs].FsystemRoot=root.getAbsolutePath();
          
        	Memory[NumFs].MaxSpace=(root.getTotalSpace()/(1024*1024));         
        	Memory[NumFs].FreeSpace=(root.getFreeSpace()/(1024*1024));
        	NumFs++;
        }
    }
}
