
/*Copyright 2011 Veeresh Rudrappa & Dilum Bandara

		   Licensed under the Apache License, Version 2.0 (the "License");
		   you may not use this file except in compliance with the License.
		   You may obtain a copy of the License at

		       http://www.apache.org/licenses/LICENSE-2.0

		   Unless required by applicable law or agreed to in writing, software
		   distributed under the License is distributed on an "AS IS" BASIS,
		   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		   See the License for the specific language governing permissions and
		   limitations under the License.
 */

/*** Contact Info *****
 * 
 * Veeresh Rudrappa 
 * Colorado State University
 * email: veeresh.rudrappa@colostate.edu
 * 
 * Dilum Bandara
 * Colorado State University
 * email: dilumb@engr.colostate.edu
 * 
 */


package com.project.extract;

import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;

public class CpuInfo {

	private Sigar sigar;
	private Shell shell;

	public String Vendor;
	public String Model;
	public int ProcSpeed;
	public int NumCores;
	long cacheSize;
	public CpuInfo()
	{
		this.shell = new Shell();
		this.sigar = shell.getSigar();;
	}

    public void output() throws SigarException {
        org.hyperic.sigar.CpuInfo[] infos = this.sigar.getCpuInfoList();
        org.hyperic.sigar.CpuInfo info = infos[0];
        cacheSize = info.getCacheSize();
        Vendor = new String(info.getVendor());
        Model = new String(info.getModel());  
        ProcSpeed= info.getMhz();
        NumCores= info.getTotalCores();
    }
    
}
