'''
Created on June 5, 2012
Modified on June 26, 2012
@author: Dilum Bandara
@version: 0.1
@license: Apache License v2.0

   Copyright 2012 H. M. N. Dilum Bandara and Anura P. Jayasumana, Colorado State
   University

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
'''

'''
Join static & dynamic attributes of a machine & prepare a 
tab seperated file
'''

dates = ['23', '24', '25', '26', '27', '28', '29'] #List of days to collect
week = '17' #Week no
fdIn = open('sameMachine.txt', 'r')

sameMachines = {} #Physical machines that reappear with a new ID
staticAtt = {}
for line in fdIn:
    tmp = line.split()
    tmp[-1].replace('\n', '')
    sameMachines[tmp[1]] = tmp[0]
fdIn.close()

fdIn = open('machines.txt', 'r')
firstLine = False
for line in fdIn:
    if firstLine == False:
        firstLine = True
        continue 
    tmp = line[:-1].split('\t')
    mID = tmp[0]
    if tmp[0] in sameMachines: mID = sameMachines[tmp[0]]
    if mID in staticAtt:
        if int(staticAtt[mID][0][0]) < int(tmp[1]):
            staticAtt[mID].append(tmp[1:])
        else: staticAtt[mID].insert(0, tmp[1:])
    else: staticAtt[mID] = [tmp[1:]]
fdIn.close()

#Modify based on attributes being collected
for mID in staticAtt: #Add header
    fdOut = open('processed_stage2/machine' + mID + '.Week' + week + '.txt', 'w') #Append
    fdOut.write('nid\ttime\tMotherBD\tCSp\tMSize\tDSize\tMSwap\tThreads\tCPUArc\t' + 
                'OS\tOSVer\tKName\tKVer\tMBID\tbytesIn\tbytesOut\tCFree\tDFree\t' + 
                '1mLd\t5mLd\t15mLd\tMFree\tSwapFree\n')
    fdOut.close()

for newMID in sameMachines: #Try each unique machine ID
    mID = sameMachines[newMID] #Find original machine ID
    fdOut = open('processed_stage2/machine' + mID + '.Week' + week + '.txt', 'a') #Append

    for day in dates:
        fdIn = None
        try:
            fdIn = open('processed_stage1/machine' + newMID + '.Ganglia.201204' + day + '.txt', 'r')
        except IOError:
            print 'File not found (file, day)', newMID, day
            continue
        firstLine = False
        for line in fdIn:
            if firstLine == False:
                firstLine = True
                continue 
            tmp = line[:-1].split('\t')
            tmpStr = mID + '\t' + tmp[0] #Machine ID + time
            if len(staticAtt[mID]) == 1: #Machine doesn't reappear
                for val in staticAtt[mID][0][2:]: tmpStr += '\t' + val
            else: #Choose which set of static attributes to use
                idx = 0 if int(tmp[0]) < staticAtt[mID][1][0] else 1
                for val in staticAtt[mID][idx][2:]: tmpStr += '\t' + val
            for val in tmp[1:]: tmpStr += '\t' + val
            fdOut.write(tmpStr + '\n')
        fdIn.close()
    fdOut.close()
print len(staticAtt)
