'''
Created on June 3, 2012
Modified on June 26, 2012
@author: Dilum Bandara
@version: 0.1
@license: Apache License v2.0

   Copyright 2012 H. M. N. Dilum Bandara and Anura P. Jayasumana, Colorado State
   University

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
'''

'''
Combine all data files.
'''

import os


machines = {} #machines[time] = [list of entries]
for root, dirs, files in os.walk('processed_17_18/'):
    for name in files:
        filename = os.path.join(root, name)
        fdIn = open(filename, 'r')
        firstLine = False
        for line in fdIn:
            if firstLine == False:
                firstLine = True
                continue
            tmp = line.split('\t')
            if tmp[1] in machines:
                machines[tmp[1]].append([tmp[0], tmp[1], tmp[3], tmp[7], tmp[16], tmp[4], tmp[21], tmp[5], \
                                   tmp[17], tmp[9], tmp[18], tmp[19], tmp[20], tmp[14], tmp[15]])
            else:
                machines[tmp[1]] = [[tmp[0], tmp[1], tmp[3], tmp[7], tmp[16], tmp[4], tmp[21], tmp[5], \
                                   tmp[17], tmp[9], tmp[18], tmp[19], tmp[20], tmp[14], tmp[15]]]
        fdIn.close()
        
fdOut = open('allMachines.txt', 'w')

#Mosify based on attributes being extracted
fdOut.write('nid\ttime\tCSp\tNCores\t\tCFree\tMSize\tMFree\tDSize\tDFree\t' +
                'OS\t1mLd\t5mLd\t15mLd\tRx\tTx\n')
times = machines.keys()
sTimes = sorted(times)
for i in sTimes:
    for j in machines[i]:
        tmpStr = ''
        for k in j: tmpStr += k + '\t'
        fdOut.write(tmpStr + '\n')
fdOut.close()
