'''
Created on June 3, 2012
Modified on June 26, 2012
@author: Dilum Bandara
@version: 0.1
@license: Apache License v2.0

   Copyright 2012 H. M. N. Dilum Bandara and Anura P. Jayasumana, Colorado State
   University

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
'''

'''
Extract time series from all machines in folder
List of sensor IDs is read from external file
'''

import os

fdSIDs = open('sensorIDs.txt', 'r')
sensorIDs = {}
sensorIDNames = []
firstLine = False

for line in fdSIDs: #Extract list of sensor IDs
    tmp = line.split()
    if firstLine == False:
        sensorIDNames = tmp[1:]
        firstLine = True
    sensorIDs[tmp[0]] = tmp[1:]
fdSIDs.close()

for root, dirs, files in os.walk('raw/'):
    for name in files:
        filename = os.path.join(root, name)
        print filename
        fdIn = open(filename, 'r')
        
        nID = -1
        values = {}
        attName = None
        defaults = {}
        for line in fdIn:
            if '<machineTimeseries machineID=' in line:
                tmp = line.split('"')
                if nID == -1: nID = tmp[1]
                if tmp[3] in sensorIDs[nID]:
                   attName = sensorIDNames[sensorIDs[nID].index(tmp[3])]  
            elif '<a ts=' in line and attName is not None:
                tmp = line.split('"')
                attValue = tmp[3]
                #Expand based on what attributes to be tracked
                if attName == 'CFree': attValue = str(round(float(attValue), 1))
                elif attName == 'MFree': attValue = str(round(float(attValue)/(1024.0*1024.0), 1))
                elif attName == 'SwapFree': attValue = str(round(float(attValue)/(1024.0*1024.0), 1))
                if tmp[1] not in values:
                    values[tmp[1]] = {attName: attValue} 
                else:
                    values[tmp[1]][attName] = attValue
            elif '<constantValue value=' in line and attName is not None:
                tmp = line.split('"')
                attValue = tmp[1]
                #Expand based on what attributes to be tracked
                if attName == 'CFree': attValue = str(round(float(attValue), 1))
                elif attName == 'MFree': attValue = str(round(float(attValue)/(1024.0*1024.0), 1))
                elif attName == 'SwapFree': attValue = str(round(float(attValue)/(1024.0*1024.0), 1))
                defaults[attName] = attValue
            elif '</machineTimeseries>' in line:
                attName = None
        fdIn.close()
        fdOut = open('processed/' + filename[:-3][4:] + 'txt', 'w')
        tmpStr = 'time'
        for i in sensorIDNames: tmpStr += '\t' + i
        fdOut.write(tmpStr + '\n')
        tmpStr = ''
        times = values.keys()
        times.sort()
        for i in times:
            tmpStr = i
            for j in range(len(sensorIDNames)):
                if sensorIDNames[j] in defaults:
                    tmpStr += '\t' + defaults[sensorIDNames[j]] 
                else: tmpStr += '\t' + values[i][sensorIDNames[j]] 
            fdOut.write(tmpStr + '\n')
        fdOut.close()

