/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.util.TempFile;
import org.apache.james.mime4j.util.TempPath;
import org.apache.james.mime4j.util.TempStorage;

class TempFileBinaryBody
extends AbstractBody
implements BinaryBody {
    private static Log log = LogFactory.getLog(TempFileBinaryBody.class);
    private Entity parent = null;
    private TempFile tempFile = null;

    public TempFileBinaryBody(InputStream is) throws IOException {
        TempPath tempPath = TempStorage.getInstance().getRootTempPath();
        this.tempFile = tempPath.createTempFile("attachment", ".bin");
        OutputStream out = this.tempFile.getOutputStream();
        IOUtils.copy(is, out);
        out.close();
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public InputStream getInputStream() throws IOException {
        return this.tempFile.getInputStream();
    }

    public void writeTo(OutputStream out) throws IOException {
        IOUtils.copy(this.getInputStream(), out);
    }
}

