/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.parser.ParseException;

public class MailboxListField
extends Field {
    private MailboxList mailboxList;
    private ParseException parseException;
    static /* synthetic */ Class class$org$apache$james$mime4j$field$MailboxListField$Parser;

    protected MailboxListField(String name, String body, String raw, MailboxList mailboxList, ParseException parseException) {
        super(name, body, raw);
        this.mailboxList = mailboxList;
        this.parseException = parseException;
    }

    public MailboxList getMailboxList() {
        return this.mailboxList;
    }

    public ParseException getParseException() {
        return this.parseException;
    }

    public static class Parser
    implements FieldParser {
        private static Log log = LogFactory.getLog(class$org$apache$james$mime4j$field$MailboxListField$Parser == null ? (class$org$apache$james$mime4j$field$MailboxListField$Parser = MailboxListField.class$("org.apache.james.mime4j.field.MailboxListField$Parser")) : class$org$apache$james$mime4j$field$MailboxListField$Parser);

        public Field parse(String name, String body, String raw) {
            MailboxList mailboxList = null;
            ParseException parseException = null;
            try {
                mailboxList = AddressList.parse(body).flatten();
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Parsing value '" + body + "': " + e.getMessage());
                }
                parseException = e;
            }
            return new MailboxListField(name, body, raw, mailboxList, parseException);
        }
    }
}

