/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.parser.ParseException;

public class MailboxField
extends Field {
    private final Mailbox mailbox;
    private final ParseException parseException;
    static /* synthetic */ Class class$org$apache$james$mime4j$field$MailboxField$Parser;

    protected MailboxField(String name, String body, String raw, Mailbox mailbox, ParseException parseException) {
        super(name, body, raw);
        this.mailbox = mailbox;
        this.parseException = parseException;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public ParseException getParseException() {
        return this.parseException;
    }

    public static class Parser
    implements FieldParser {
        private static Log log = LogFactory.getLog(class$org$apache$james$mime4j$field$MailboxField$Parser == null ? (class$org$apache$james$mime4j$field$MailboxField$Parser = MailboxField.class$("org.apache.james.mime4j.field.MailboxField$Parser")) : class$org$apache$james$mime4j$field$MailboxField$Parser);

        public Field parse(String name, String body, String raw) {
            Mailbox mailbox = null;
            ParseException parseException = null;
            try {
                MailboxList mailboxList = AddressList.parse(body).flatten();
                if (mailboxList.size() > 0) {
                    mailbox = mailboxList.get(0);
                }
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Parsing value '" + body + "': " + e.getMessage());
                }
                parseException = e;
            }
            return new MailboxField(name, body, raw, mailbox, parseException);
        }
    }
}

