/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.ParseException;

public class DateTimeField
extends Field {
    private Date date;
    private ParseException parseException;
    static /* synthetic */ Class class$org$apache$james$mime4j$field$DateTimeField$Parser;

    protected DateTimeField(String name, String body, String raw, Date date, ParseException parseException) {
        super(name, body, raw);
        this.date = date;
        this.parseException = parseException;
    }

    public Date getDate() {
        return this.date;
    }

    public ParseException getParseException() {
        return this.parseException;
    }

    public static class Parser
    implements FieldParser {
        private static Log log = LogFactory.getLog(class$org$apache$james$mime4j$field$DateTimeField$Parser == null ? (class$org$apache$james$mime4j$field$DateTimeField$Parser = DateTimeField.class$("org.apache.james.mime4j.field.DateTimeField$Parser")) : class$org$apache$james$mime4j$field$DateTimeField$Parser);

        public Field parse(String name, String body, String raw) {
            Date date = null;
            ParseException parseException = null;
            try {
                date = DateTime.parse(body).getDate();
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Parsing value '" + body + "': " + e.getMessage());
                }
                parseException = e;
            }
            return new DateTimeField(name, body, raw, date, parseException);
        }
    }
}

