/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BodyDescriptor {
    private static Log log = LogFactory.getLog(BodyDescriptor.class);
    private String mimeType = "text/plain";
    private String boundary = null;
    private String charset = "us-ascii";
    private String transferEncoding = "7bit";
    private Map parameters = new HashMap();
    private boolean contentTypeSet = false;
    private boolean contentTransferEncSet = false;

    public BodyDescriptor() {
        this(null);
    }

    public BodyDescriptor(BodyDescriptor parent) {
        this.mimeType = parent != null && parent.isMimeType("multipart/digest") ? "message/rfc822" : "text/plain";
    }

    public void addField(String name, String value) {
        if ((name = name.trim().toLowerCase()).equals("content-transfer-encoding") && !this.contentTransferEncSet) {
            this.contentTransferEncSet = true;
            if ((value = value.trim().toLowerCase()).length() > 0) {
                this.transferEncoding = value;
            }
        } else if (name.equals("content-type") && !this.contentTypeSet) {
            String c;
            this.contentTypeSet = true;
            value = value.trim();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char c2 = value.charAt(i);
                if (c2 == '\r' || c2 == '\n') continue;
                sb.append(c2);
            }
            Map params = this.getHeaderParams(sb.toString());
            String main = (String)params.get("");
            if (main != null) {
                main = main.toLowerCase().trim();
                int index = main.indexOf(47);
                boolean valid = false;
                if (index != -1) {
                    String type = main.substring(0, index).trim();
                    String subtype = main.substring(index + 1).trim();
                    if (type.length() > 0 && subtype.length() > 0) {
                        main = type + "/" + subtype;
                        valid = true;
                    }
                }
                if (!valid) {
                    main = null;
                }
            }
            String b = (String)params.get("boundary");
            if (main != null && (main.startsWith("multipart/") && b != null || !main.startsWith("multipart/"))) {
                this.mimeType = main;
            }
            if (this.isMultipart()) {
                this.boundary = b;
            }
            if ((c = (String)params.get("charset")) != null && (c = c.trim()).length() > 0) {
                this.charset = c.toLowerCase();
            }
            this.parameters.putAll(params);
            this.parameters.remove("");
            this.parameters.remove("boundary");
            this.parameters.remove("charset");
        }
    }

    private Map getHeaderParams(String headerValue) {
        String rest;
        String main;
        HashMap<String, String> result = new HashMap<String, String>();
        if (headerValue.indexOf(";") == -1) {
            main = headerValue;
            rest = null;
        } else {
            main = headerValue.substring(0, headerValue.indexOf(";"));
            rest = headerValue.substring(main.length() + 1);
        }
        result.put("", main);
        if (rest != null) {
            char[] chars = rest.toCharArray();
            StringBuffer paramName = new StringBuffer();
            StringBuffer paramValue = new StringBuffer();
            boolean READY_FOR_NAME = false;
            boolean IN_NAME = true;
            int READY_FOR_VALUE = 2;
            int IN_VALUE = 3;
            int IN_QUOTED_VALUE = 4;
            int VALUE_DONE = 5;
            int ERROR = 99;
            int state = 0;
            boolean escaped = false;
            block24: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (state) {
                    case 99: {
                        if (c != ';') continue block24;
                        state = 0;
                        continue block24;
                    }
                    case 0: {
                        if (c == '=') {
                            log.error("Expected header param name, got '='");
                            state = 99;
                            continue block24;
                        }
                        paramName = new StringBuffer();
                        paramValue = new StringBuffer();
                        state = 1;
                    }
                    case 1: {
                        if (c == '=') {
                            if (paramName.length() == 0) {
                                state = 99;
                                continue block24;
                            }
                            state = 2;
                            continue block24;
                        }
                        paramName.append(c);
                        continue block24;
                    }
                    case 2: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '\"': {
                                state = 4;
                                break;
                            }
                            default: {
                                state = 3;
                                fallThrough = true;
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 3: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': 
                            case ';': {
                                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
                                state = 5;
                                fallThrough = true;
                                break;
                            }
                            default: {
                                paramValue.append(c);
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 5: {
                        switch (c) {
                            case ';': {
                                state = 0;
                                continue block24;
                            }
                            case '\t': 
                            case ' ': {
                                continue block24;
                            }
                        }
                        state = 99;
                        continue block24;
                    }
                    case 4: {
                        switch (c) {
                            case '\"': {
                                if (!escaped) {
                                    result.put(paramName.toString().trim().toLowerCase(), paramValue.toString());
                                    state = 5;
                                    continue block24;
                                }
                                escaped = false;
                                paramValue.append(c);
                                continue block24;
                            }
                            case '\\': {
                                if (escaped) {
                                    paramValue.append('\\');
                                }
                                escaped = !escaped;
                                continue block24;
                            }
                        }
                        if (escaped) {
                            paramValue.append('\\');
                        }
                        escaped = false;
                        paramValue.append(c);
                    }
                }
            }
            if (state == 3) {
                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
            }
        }
        return result;
    }

    public boolean isMimeType(String mimeType) {
        return this.mimeType.equals(mimeType.toLowerCase());
    }

    public boolean isMessage() {
        return this.mimeType.equals("message/rfc822");
    }

    public boolean isMultipart() {
        return this.mimeType.startsWith("multipart/");
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getCharset() {
        return this.charset;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public boolean isBase64Encoded() {
        return "base64".equals(this.transferEncoding);
    }

    public boolean isQuotedPrintableEncoded() {
        return "quoted-printable".equals(this.transferEncoding);
    }

    public String toString() {
        return this.mimeType;
    }
}

