/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.TextBody;

public class StringBody
extends AbstractBody
implements TextBody,
ContentBody {
    private final byte[] content;
    private final Charset charset;

    public StringBody(String text, Charset charset) throws UnsupportedEncodingException {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        this.content = text.getBytes(charset.name());
        this.charset = charset;
    }

    public StringBody(String text) throws UnsupportedEncodingException {
        this(text, null);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.charset);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        IOUtils.copy((InputStream)new ByteArrayInputStream(this.content), out);
    }

    public String getTransferEncoding() {
        return "8bit";
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMimeType() {
        return "text/plain";
    }

    public long getContentLength() {
        return this.content.length;
    }

    public String getFilename() {
        return null;
    }
}

