/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BinaryBody;

public class InputStreamBody
extends AbstractBody
implements BinaryBody,
ContentBody {
    private final InputStream in;
    private final String filename;

    public InputStreamBody(InputStream in, String filename) {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        this.in = in;
        this.filename = filename;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        try {
            IOUtils.copy(this.in, out);
        }
        finally {
            this.in.close();
        }
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public Charset getCharset() {
        return null;
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public long getContentLength() {
        return -1L;
    }

    public String getFilename() {
        return this.filename;
    }
}

