/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BinaryBody;

public class FileBody
extends AbstractBody
implements BinaryBody,
ContentBody {
    private final File file;

    public FileBody(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream in = new FileInputStream(this.file);
        try {
            IOUtils.copy((InputStream)in, out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public Charset getCharset() {
        return null;
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public long getContentLength() {
        return this.file.length();
    }

    public String getFilename() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }
}

