/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import org.apache.http.entity.mime.ContentDescriptor;
import org.apache.http.entity.mime.RFC822Header;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.message.BodyPart;

public class FormBodyPart
extends BodyPart {
    private final String name;

    public FormBodyPart(String name, ContentBody body) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = name;
        RFC822Header header = new RFC822Header();
        this.setHeader(header);
        this.setBody(body);
        this.generateContentDisp(body);
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    protected void generateContentDisp(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Content-Disposition");
        buffer.append(": form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body.getFilename());
            buffer.append("\"");
        }
        this.getHeader().addField(Field.parse(buffer.toString()));
    }

    protected void generateContentType(ContentDescriptor desc) {
        if (desc.getMimeType() != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Content-Type");
            buffer.append(": ");
            buffer.append(desc.getMimeType());
            if (desc.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(desc.getCharset().name());
            }
            this.getHeader().addField(Field.parse(buffer.toString()));
        }
    }

    protected void generateTransferEncoding(ContentDescriptor desc) {
        if (desc.getTransferEncoding() != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Content-Transfer-Encoding");
            buffer.append(": ");
            buffer.append(desc.getTransferEncoding());
            this.getHeader().addField(Field.parse(buffer.toString()));
        }
    }
}

