/*
 * Decompiled with CFR 0.152.
 */
package com.project.extract;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.util.PrintfFormat;

public class Uptime {
    public String Uptime;
    private static Object[] loadAvg = new Object[3];
    private static PrintfFormat formatter = new PrintfFormat("%.2f, %.2f, %.2f");
    private Sigar sigar;
    private Shell shell = new Shell();

    public Uptime() {
        this.sigar = this.shell.getSigar();
    }

    public String getUsageShort() {
        return "Display how long the system has been running";
    }

    public void output() throws SigarException {
        this.Uptime = new String(com.project.extract.Uptime.getInfo(this.sigar));
    }

    public static String getInfo(SigarProxy sigar) throws SigarException {
        String loadAverage;
        double uptime = sigar.getUptime().getUptime();
        try {
            double[] avg = sigar.getLoadAverage();
            com.project.extract.Uptime.loadAvg[0] = new Double(avg[0]);
            com.project.extract.Uptime.loadAvg[1] = new Double(avg[1]);
            com.project.extract.Uptime.loadAvg[2] = new Double(avg[2]);
            loadAverage = "load average: " + formatter.sprintf(loadAvg);
        }
        catch (SigarNotImplementedException e) {
            loadAverage = "(load average unknown)";
        }
        return "  " + com.project.extract.Uptime.getCurrentTime() + "  up " + com.project.extract.Uptime.formatUptime(uptime) + ", " + loadAverage;
    }

    private static String formatUptime(double uptime) {
        String retval = "";
        int days = (int)uptime / 86400;
        if (days != 0) {
            retval = String.valueOf(retval) + days + " " + (days > 1 ? "days" : "day") + ", ";
        }
        int minutes = (int)uptime / 60;
        int hours = minutes / 60;
        retval = (hours %= 24) != 0 ? String.valueOf(retval) + hours + ":" + minutes : String.valueOf(retval) + (minutes %= 60) + " min";
        return retval;
    }

    private static String getCurrentTime() {
        return new SimpleDateFormat("h:mm a").format(new Date());
    }
}

