/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.james.mime4j.decoder.Base64OutputStream;
import org.apache.james.mime4j.decoder.LineBreakingOutputStream;

public class CodecUtil {
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte[] CRLF_CRLF = new byte[]{13, 10, 13, 10};
    private static final int DEFAULT_ENCODING_BUFFER_SIZE = 1024;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final byte EQUALS = 61;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte QUOTED_PRINTABLE_LAST_PLAIN = 126;
    private static final int QUOTED_PRINTABLE_MAX_LINE_LENGTH = 76;
    private static final int QUOTED_PRINTABLE_OCTETS_PER_ESCAPE = 3;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int inputLength;
        byte[] buffer = new byte[1024];
        while (-1 != (inputLength = in.read(buffer))) {
            out.write(buffer, 0, inputLength);
        }
    }

    public static void encodeQuotedPrintableBinary(InputStream in, OutputStream out) throws IOException {
        QuotedPrintableEncoder encoder = new QuotedPrintableEncoder(1024, true);
        encoder.encode(in, out);
    }

    public static void encodeQuotedPrintable(InputStream in, OutputStream out) throws IOException {
        QuotedPrintableEncoder encoder = new QuotedPrintableEncoder(1024, false);
        encoder.encode(in, out);
    }

    public static void encodeBase64(InputStream in, OutputStream out) throws IOException {
        Base64Encoder encoder = new Base64Encoder(1024);
        encoder.encode(in, out);
    }

    public static OutputStream wrapQuotedPrintable(OutputStream out, boolean binary) throws IOException {
        return new QuotedPrintableOutputStream(out, binary);
    }

    public static OutputStream wrapBase64(OutputStream out) throws IOException {
        return new Base64OutputStream(new OutputStreamWriter(new LineBreakingOutputStream(out, 76)){

            public void close() throws IOException {
                this.flush();
            }
        });
    }

    private static final class Base64Encoder {
        private static final int MASK = 63;
        private static final int FIRST_MASK = 0xFC0000;
        private static final int SECOND_MASK = 258048;
        private static final int THIRD_MASK = 4032;
        private static final int FORTH_MASK = 63;
        private static final byte[] ENCODING = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private final byte[] in;
        private final byte[] out;

        public Base64Encoder(int inputBufferSize) {
            this.in = new byte[inputBufferSize];
            int outputBufferSize = (int)Math.floor((float)(4 * inputBufferSize) / 3.0f) + 3;
            outputBufferSize += 2 * (int)Math.floor((float)outputBufferSize / 76.0f);
            this.out = new byte[outputBufferSize];
        }

        public void encode(InputStream inStream, OutputStream outStream) throws IOException {
            int inputLength;
            while ((inputLength = inStream.read(this.in)) > -1) {
                int outputLength = this.encodeInputBuffer(this.in, 0, inputLength);
                if (outputLength <= 0) continue;
                outStream.write(this.out, 0, outputLength);
            }
        }

        private int encodeInputBuffer(byte[] in, int pos, int inputLength) {
            if (inputLength == 0) {
                return 0;
            }
            int inputEnd = pos + inputLength;
            int inputIndex = pos;
            int outputIndex = 0;
            while (inputEnd - inputIndex > 2) {
                int one = this.toInt(in[inputIndex++]) << 16;
                int two = this.toInt(in[inputIndex++]) << 8;
                int three = this.toInt(in[inputIndex++]);
                int quantum = one | two | three;
                int index = (quantum & 0xFC0000) >> 18;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = (quantum & 0x3F000) >> 12;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = (quantum & 0xFC0) >> 6;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                index = quantum & 0x3F;
                outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
            }
            switch (inputEnd - inputIndex) {
                case 1: {
                    int quantum = in[inputIndex++] << 16;
                    int index = (quantum & 0xFC0000) >> 18;
                    outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                    index = (quantum & 0x3F000) >> 12;
                    outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                    outputIndex = this.setResult(this.out, outputIndex, (byte)61);
                    outputIndex = this.setResult(this.out, outputIndex, (byte)61);
                    break;
                }
                case 2: {
                    int quantum = (in[inputIndex++] << 16) + (in[inputIndex++] << 8);
                    int index = (quantum & 0xFC0000) >> 18;
                    outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                    index = (quantum & 0x3F000) >> 12;
                    outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                    index = (quantum & 0xFC0) >> 6;
                    outputIndex = this.setResult(this.out, outputIndex, ENCODING[index]);
                    outputIndex = this.setResult(this.out, outputIndex, (byte)61);
                }
            }
            return outputIndex;
        }

        private int toInt(byte b) {
            return 0xFF & b;
        }

        private int setResult(byte[] results, int outputIndex, byte value) {
            results[outputIndex++] = value;
            outputIndex = this.checkLineLength(results, outputIndex);
            return outputIndex;
        }

        private int checkLineLength(byte[] results, int outputIndex) {
            if (outputIndex == 76 || outputIndex > 76 && ((double)outputIndex - 2.0 * Math.floor((float)outputIndex / 76.0f - 1.0f)) % 76.0 == 0.0) {
                results[outputIndex++] = 13;
                results[outputIndex++] = 10;
            }
            return outputIndex;
        }
    }

    static class QuotedPrintableOutputStream
    extends FilterOutputStream {
        QuotedPrintableEncoder encoder;

        public QuotedPrintableOutputStream(OutputStream arg0, boolean binary) {
            super(arg0);
            this.encoder = new QuotedPrintableEncoder(1024, binary);
            this.encoder.initEncoding(this.out);
        }

        public void close() throws IOException {
            this.encoder.completeEncoding();
        }

        public void flush() throws IOException {
            this.encoder.flushOutput();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.encoder.encodeChunk(b, off, len);
        }

        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("QuotedPrintableOutputStream filter does not support byte per byte writes");
        }
    }

    private static final class QuotedPrintableEncoder {
        private final byte[] inBuffer;
        private final byte[] outBuffer;
        private final boolean binary;
        private boolean pendingSpace;
        private boolean pendingTab;
        private boolean pendingCR;
        private int nextSoftBreak;
        private int outputIndex;
        private OutputStream out;

        public QuotedPrintableEncoder(int bufferSize, boolean binary) {
            this.inBuffer = new byte[bufferSize];
            this.outBuffer = new byte[3 * bufferSize];
            this.outputIndex = 0;
            this.nextSoftBreak = 77;
            this.out = null;
            this.binary = binary;
            this.pendingSpace = false;
            this.pendingTab = false;
            this.pendingCR = false;
        }

        void initEncoding(OutputStream out) {
            this.out = out;
            this.pendingSpace = false;
            this.pendingTab = false;
            this.pendingCR = false;
            this.nextSoftBreak = 77;
        }

        void encodeChunk(byte[] buffer, int off, int len) throws IOException {
            for (int inputIndex = off; inputIndex < len + off; ++inputIndex) {
                this.encode(buffer[inputIndex]);
            }
        }

        void completeEncoding() throws IOException {
            this.writePending();
            this.flushOutput();
        }

        public void encode(InputStream in, OutputStream out) throws IOException {
            int inputLength;
            this.initEncoding(out);
            while ((inputLength = in.read(this.inBuffer)) > -1) {
                this.encodeChunk(this.inBuffer, 0, inputLength);
            }
            this.completeEncoding();
        }

        private void writePending() throws IOException {
            if (this.pendingSpace) {
                this.plain((byte)32);
            } else if (this.pendingTab) {
                this.plain((byte)9);
            } else if (this.pendingCR) {
                this.plain((byte)13);
            }
            this.clearPending();
        }

        private void clearPending() throws IOException {
            this.pendingSpace = false;
            this.pendingTab = false;
            this.pendingCR = false;
        }

        private void encode(byte next) throws IOException {
            if (next == 10) {
                if (this.binary) {
                    this.writePending();
                    this.escape(next);
                } else if (this.pendingCR) {
                    if (this.pendingSpace) {
                        this.escape((byte)32);
                    } else if (this.pendingTab) {
                        this.escape((byte)9);
                    }
                    this.lineBreak();
                    this.clearPending();
                } else {
                    this.writePending();
                    this.plain(next);
                }
            } else if (next == 13) {
                if (this.binary) {
                    this.escape(next);
                } else {
                    this.pendingCR = true;
                }
            } else {
                this.writePending();
                if (next == 32) {
                    if (this.binary) {
                        this.escape(next);
                    } else {
                        this.pendingSpace = true;
                    }
                } else if (next == 9) {
                    if (this.binary) {
                        this.escape(next);
                    } else {
                        this.pendingTab = true;
                    }
                } else if (next < 32) {
                    this.escape(next);
                } else if (next > 126) {
                    this.escape(next);
                } else if (next == 61) {
                    this.escape(next);
                } else {
                    this.plain(next);
                }
            }
        }

        private void plain(byte next) throws IOException {
            if (--this.nextSoftBreak <= 1) {
                this.softBreak();
            }
            this.write(next);
        }

        private void escape(byte next) throws IOException {
            if (--this.nextSoftBreak <= 3) {
                this.softBreak();
            }
            int nextUnsigned = next & 0xFF;
            this.write((byte)61);
            --this.nextSoftBreak;
            this.write(HEX_DIGITS[nextUnsigned >> 4]);
            --this.nextSoftBreak;
            this.write(HEX_DIGITS[nextUnsigned % 16]);
        }

        private void write(byte next) throws IOException {
            this.outBuffer[this.outputIndex++] = next;
            if (this.outputIndex >= this.outBuffer.length) {
                this.flushOutput();
            }
        }

        private void softBreak() throws IOException {
            this.write((byte)61);
            this.lineBreak();
        }

        private void lineBreak() throws IOException {
            this.write((byte)13);
            this.write((byte)10);
            this.nextSoftBreak = 76;
        }

        private void flushOutput() throws IOException {
            if (this.outputIndex < this.outBuffer.length) {
                this.out.write(this.outBuffer, 0, this.outputIndex);
            } else {
                this.out.write(this.outBuffer);
            }
            this.outputIndex = 0;
        }
    }
}

