#include "timer.h"
#include <semaphore.h>

#define _POSIX_C_SOURCE 199506L

#define OUR_CLOCK CLOCK_REALTIME

pthread_t pthread_timer;
sem_t timer_sem;
static void* run_timer(void* t);

static void* run_timer(void* p)
{
  struct timespec it;  // interval
  struct timespec rem; // remaining time

  it.tv_sec = 0;
  it.tv_nsec = 20000000; // 20 msec

  /* initialize semaphore */
  sem_init(&timer_sem, 0, 1);

  while(1) {
    sem_wait(&timer_sem);
    nanosleep(&it, &rem);
    sem_post(&timer_sem);
  }
}
#if 0
void timer_intr(int sig, siginfo_t *extra, void *cruft)
{
   return;
}

timer_t mytimer;

void create_timer()
{
  
  struct itimerspec i;
  struct sigaction sa;
  struct sigevent timer_event;

  sigemptyset(&sa.sa_mask);
  sa.sa_flags=SA_SIGINFO;         /*real-time signal*/
  sa.sa_sigaction=timer_intr;     /*pointer to action*/

  if(sigaction(SIGRTMIN, &sa, NULL) < 0){
    perror("sigaction error");
    exit(1);
  }
        
  /*
   * create a timer based upon the CLOCK_REALTIME clock 
   */
  i.it_interval.tv_sec=0;
  i.it_interval.tv_nsec=0;
  i.it_value.tv_sec = 0;
  i.it_value.tv_nsec = 0;

  timer_event.sigev_notify=SIGEV_SIGNAL;
  timer_event.sigev_signo= SIGRTMIN;
  timer_event.sigev_value.sival_ptr = (void *)&mytimer;

  if (timer_create(CLOCK_REALTIME, &timer_event, &mytimer) < 0){
    perror("timer create error");
    exit(1);
  }
  /* relative timer, go off at the end of the interval*/
  if(timer_settime(mytimer, 0 , &i, NULL) < 0){
     perror("settimer");
     exit(3);
  }

}
#endif
void create_time_ticker()
{
  pthread_create(&pthread_timer, NULL, run_timer, NULL); 
}

void cancel_timer()
{
  sem_destroy(&timer_sem);
  pthread_cancel(pthread_timer);
}

int check_timeout()
{
  int rc;

  rc = sem_trywait(&timer_sem);
  if(rc == 0) 
    return 1;
  else
    return 0;
}

void release_timer_semaphore()
{
  sem_post(&timer_sem);
}

float elapse_time(int flag, int id)
{
   static struct timeval start[10];
   struct timeval end;
   struct timezone tz;
   float  elapsed = 1.0;

   if(flag == START) {
     gettimeofday(&start[id%10], &tz);

     return 0.0;
   }
   else if(flag == END) {
     gettimeofday(&end, &tz);
     elapsed = (end.tv_sec - start[id%10].tv_sec) * 1000000.0 + (end.tv_usec - start[id%10].tv_usec)*1.0;

     // printf("Time Elapsed [%f milisec ] \n", elapsed/1000.0);
   }

   return  (elapsed/1000.0);
}
