#include "packet.h"

  /* setup the queue */
PKTQueue* init_packet_queue(PKTQueue* queue)
{
  queue->head = NULL;
  queue->tail = NULL;
  queue->size = 0;
  return queue;
}

PKTNode* init_packet_node(char* mes, int len)
{
  PKTNode* new_node;  
  new_node = (PKTNode*)calloc(sizeof(PKTNode), 1);
  new_node->next = NULL;  
  new_node->pkt = mes;
  new_node->len = len;                      /* length of message + checksum - null_term */
  return new_node;
}

  /* add new message to q */
void enqueue_packet(PKTQueue* queue, PKTNode* qnode)
{ 
  if (queue->size == 0) {
    queue->head = qnode;
    queue->tail = qnode;
  }
  else {
    queue->tail->next = qnode;
    queue->tail = qnode;
  }
  queue->size++;
}

  /* remove message from q */
PKTNode* dequeue_packet(PKTQueue* queue)
{
  PKTNode* temp;

  if (queue->size == 0) {
    return  NULL;
  }
  temp = queue->head;  
  if (queue->size == 1) {    
    queue->head = NULL;
    queue->tail = NULL; 
  } 
  else {
    queue->head = queue->head->next;
  }

  queue->size--;
  return temp;
}

