#include <stdio.h>
#include <math.h>
#include "packet.h"
#include "radar.h"

#define MAX_PKT_SIZE 1420
#define SAMPLE    (float) 64.0
#define MAX_RATE  (float) 10.0

extern int Random;

typedef struct sample {
  unsigned short index;
  unsigned short bits;
} SampleType;

typedef struct samples {
  int ray_num;
  int nSample;
  SampleType startSample[64];
} SelectedSample;

typedef struct PacketList {
  int nPacket;
  Packet* pktlst[1024];
} PacketList;

static void app_packetize_type1(SelectedSample*, Ray *, int, PKTQueue*);
static Packet* create_packet_type1(Ray*, int, int, int, int, int);
static void select_sample_type1(int , SelectedSample *);
static void select_sample_random(int , SelectedSample *);
static void set_bitpattern(SelectedSample *, float, float);

void select_sample
(
  int 		currRate, 
  int 		type, 
  int 		blkno, 
  char* 	data, 
  PKTQueue * 	queue
)
{
  SelectedSample *selected_sample;

  selected_sample = (SelectedSample *) calloc(sizeof(SelectedSample), 1);
  selected_sample->ray_num = blkno;

  /*
   * sample selection
   */
  switch(type)
  {
    case TIME_SERIES_TYPE1:
      if(Random) 
        select_sample_random(currRate, selected_sample);
      else 
        select_sample_type1(currRate, selected_sample);
      /* packetize the selected samples */
      app_packetize_type1(selected_sample, (Ray *) data, currRate, queue);
      break;

    case TIME_SERIES_TYPE2:
      break;

    default:
     break;
  }
#if 0
  int i;
  printf("Block numner %d [%d] \n", selected_sample->ray_num, selected_sample->nSample);
  for(i = 0; i < selected_sample->nSample; i++) 
    printf("%d [%x] ", selected_sample->startSample[i].index,  selected_sample->startSample[i].bits);
#endif   
  free(selected_sample);
  return;
}


static void  select_sample_type1(int currRate, SelectedSample *selected)
{
  float rate;
  float total = 0.0;
  int   i, sample;
  float interval;
  unsigned short mask = 0x1;

  rate = (float ) currRate;
  mask = mask << currRate;
  // calc. no. samples
  selected->nSample = (int) floorf(SAMPLE*(rate/MAX_RATE)-1 );

  interval = MAX_RATE / rate;

  for(i=0; i < selected->nSample;i++)
  {
     sample = (int) floor(total);
     selected->startSample[i].index = sample;
     selected->startSample[i].bits = mask;
     total += interval;
  }

  for(i = 1; i < (int ) rate; i++) {
     set_bitpattern(selected, rate, (float) i);
  }

}

 
//   select samples randomly
static void  select_sample_random(int currRate, SelectedSample *selected)
{
  float rate;
  float total = 0.0;
  int   i, sample;
  float interval;
  SelectedSample *foo;

  foo = (SelectedSample *) calloc(sizeof(SelectedSample), 1);
  select_sample_type1(10, foo);

  rate = (float ) currRate;
  // mask = mask << currRate;
  // calc. no. samples
  selected->nSample = (int) floorf(SAMPLE*(rate/MAX_RATE)-1);

  interval = 1.0;

  for(i=0; i < selected->nSample;i++)
  {
     sample = (int) floor(total);
     selected->startSample[i].index = sample;
     selected->startSample[i].bits = foo->startSample[i].bits;

     total += interval;
  }

  free(foo);

/*
  for(i = 1; i < (int ) rate; i++) {
     set_bitpattern(selected, rate, (float) i);
  }
*/

}

void set_bitpattern(SelectedSample * selected, float currRate, float rate)
{
  float interval, total = 0.0;
  int   i, sample, count = 0;
  unsigned short mask = 1;

  interval = currRate / rate;

  count = (int ) rate;
  mask = mask << count;

  total = (float) selected->nSample;
  count = (int ) ceilf(total * (rate/currRate));

  total = 0;
  for(i = 0; i < count; i++) {
    sample = (int ) floor(total);
    selected->startSample[sample].bits |= mask;
    total += interval;
  }
}

static void app_packetize_type1(SelectedSample  *samples, Ray *ray, int currRate, PKTQueue *queue)
{
  Packet * frame;
  int i;
  int startGate, endGate;
  PKTNode *newnode;
  // int max = (int ) ((currRate / (int ) MAX_RATE) * 192);
  
  for(i  = 0; i < samples->nSample; i++) {
    startGate = 0;
    endGate = SAMPLE_SEGMENT_TYPE1;
    while(startGate != NUM_OF_GATE) {
      // if(max > queue->size) {
        frame = create_packet_type1(ray, samples->ray_num, startGate, endGate-1, samples->startSample[i].index, currRate);
        newnode = init_packet_node((char *) frame, MAX_PKT_SIZE);
        newnode->bitpattern = samples->startSample[i].bits;
        enqueue_packet(queue, newnode);
      // }

      startGate = endGate;
      endGate += SAMPLE_SEGMENT_TYPE1;
      if(endGate > NUM_OF_GATE) endGate = NUM_OF_GATE;
    }
  }

  return; 
}

static Packet * create_packet_type1(Ray *ray, int ray_num, int startgate, int endgate, int sampleIdx, int currRate)
{
  static int blkno = -1;
  int i;
  static PacketList *pktlst_type1;
  Packet * pkt;
  RadarPkt *radar_pkt;
  register unsigned short mask = 0x0001;

  // allocate packet list
  if( blkno == -1 )  {
    blkno = ray_num;
    pktlst_type1 = (PacketList *) calloc(sizeof(PacketList), 1);
  }

  if( blkno != ray_num) { /* is it new ray? */  
    blkno = ray_num;

    // clear previous packet list
    for(i = 0; i < pktlst_type1->nPacket; i++) {
      free(pktlst_type1->pktlst[i]);
      pktlst_type1->pktlst[i] = NULL;
    }
    pktlst_type1->nPacket = 0;
  }
     
    
  // search for a packet with the same information 
  for(i = 0; i < pktlst_type1->nPacket; i++) {
    pkt =  pktlst_type1->pktlst[i];
    radar_pkt = (RadarPkt *) pkt->p.datpkt.payload;

    if( (radar_pkt->h.start_sample == sampleIdx) && 
        (radar_pkt->h.start_sample_first_gate == startgate) &&
        (radar_pkt->h.start_sample_last_gate == endgate)) {
      pkt->current_rate = (unsigned char) currRate;
      return (pktlst_type1->pktlst[i]);
    }
  }

  // create new packet
  pkt = (Packet *) malloc(1600);
  pkt->opcode = DATA_PKT; // data packet 
  pkt->pdp = mask << currRate;           // not implemented 
  pkt->version = 1;       // version 1.0
  pkt->p.datpkt.blkno = ray_num;
  pkt->p.datpkt.plen = sizeof(RadarHeader) + sizeof(RadarParams) + SAMPLE_SIZE * (endgate - startgate);
  pkt->current_rate = (unsigned char ) currRate;
  radar_pkt = (RadarPkt *) pkt->p.datpkt.payload;  
  radar_pkt->h.type = TIME_SERIES_TYPE1;
  radar_pkt->h.ray_num = ray_num;
  radar_pkt->h.start_sample = sampleIdx;
  radar_pkt->h.end_sample = sampleIdx;
  radar_pkt->h.start_sample_first_gate = startgate;
  radar_pkt->h.start_sample_last_gate = endgate;
  radar_pkt->h.end_sample_last_gate = endgate;
  radar_pkt->h.end_sample_first_gate = startgate;
  radar_pkt->h.plen = (endgate - startgate) * SAMPLE_SIZE;
  memcpy((char *) &radar_pkt->params, (char *) &ray->param, sizeof(RadarParams));
  // copy radar data 
  radar_pkt->h.plen = (int ) (endgate-startgate) * sizeof(Sample);
  memcpy((char *) radar_pkt->payload, (char *) &ray->radar_data[sampleIdx*NUM_OF_GATE + startgate], radar_pkt->h.plen);

  pktlst_type1->pktlst[pktlst_type1->nPacket] =  pkt;
  pktlst_type1->nPacket++;

  return  pkt;
}

