/*
 *  FILE   : radar.h
 *  AUTHOR : Panho Lee 
 *  NOTES  : Define radar specific structure and
 *           all forward declarations.
 */
#include "packet.h"
#ifndef _radar_H
#define  NUM_OF_SAMPLE  64
#define  NUM_OF_GATE    256
#define  SAMPLE_SIZE     16
#define  MAX_BIT_RATE    10
#define  TIME_SERIES_TYPE1 1
#define  TIME_SERIES_TYPE2 2

#define  SAMPLE_SEGMENT_TYPE1 86
#define  SAMPLE_SEGMENT_TYPE2 43

typedef struct sample_format {
  float Ih; 
  float Qh; 
  float nIh; 
  float nQh; 
} Sample;

typedef struct radar_op_param {
  float   range_start;
  float   range_bin;
  int     gates;
  int     samples;
  float   azimuth;
  float   elevation;
  int     mode;
}  RadarParams;

typedef struct ray_fromat {
  RadarParams param;
  Sample  radar_data[NUM_OF_GATE*NUM_OF_SAMPLE]; 
} Ray;

typedef struct radar_packet_header  {
  short int   type;
  short int   ray_num;
  unsigned short sample_pattern;
  short int   start_sample;
  short int   end_sample;
  short int   start_sample_first_gate;
  short int   start_sample_last_gate;
  short int   end_sample_first_gate;
  short int   end_sample_last_gate;
  short int   plen;
} RadarHeader;

typedef struct radar_packet {
  RadarHeader  h;
  RadarParams params;
  unsigned char payload[1392];
}  RadarPkt;

void select_sample(int , int, int, char *, PKTQueue*);

#endif    /* _radar_H */
