/* pson.c  */
/* Panho Lee */

#include "ccl.h"
#include "onl.h"
#include "cclqueue.h"
#include "application.h"

#define PACKET_COUNT  1000

int DEBUG = 0;
int verbose = 0;
int packet_size = 0;
int  myID;
int service_port;
int  destination;
int run_mode;
int max;
int min;
int iter;

extern void readPackets(Session *c);
static void forever();
static void result_open();

FILE *output;

void Usage()
{
printf("\tpson [-s nclient|-c server|-i] [-hvd] [-l packet_size] [-p service_port]\n");
printf("\t-h            print this message.\n");
printf("\t-v            verbose mode.\n");
printf("\t-i  <myid>    run in intermediate mode.\n");
printf("\t-c  <myid>    run in client mode, connectiong to <server> \n");
printf("\t-s  <myid>    run in server mode \n");
printf("\t-d  <dst>     destination(server) id.\n");
printf("\t-l  <size>    set the length(B) of the probing in byte.\n");
printf("\t-p  <port>    indicate the dst machine's listening port.\n");
printf("\t-m  <bw>      indicate the minimum bandwidth.\n");
printf("\t-t  <bw>      indicate the target bandwidth.\n");
printf("\t-f  <type>    indicate the framing type.\n");
printf("\t-r  <ribfile> indicate the rib file name, which contains routing info.\n");

exit(1);
}

int  Random;
int main(int argc, char *argv[])
{
  extern char *optarg;
  int opt;
 extern void appmgr_plugin(void *p);
 extern void casa_app_plugin(void *p); 

  while ((opt = getopt(argc, argv, "c:d:s:i:r:l:m:n:p:f:t:ahv")) != EOF) {
    switch ((char)opt) {
      case 'c':
	run_mode = C_NODE;
	myID = atoi(optarg);
        break;
      case 'i':
	run_mode = I_NODE;
	myID = atoi(optarg);
	break;
      case 's':
	run_mode = S_NODE;
	myID = atoi(optarg);
      break;	
      case 'r':
	run_mode = R_NODE;
	myID = atoi(optarg);
      break;	
      case 'd':
        destination = atoi(optarg);
      break;
      case 'm':
        min = atoi(optarg);
      break;
      case 't':
        max = atoi(optarg);
      break;
      case 'l':
	packet_size = atoi(optarg);
      break;
      case 'n':
	iter = atoi(optarg);
      break;
      case 'p':
	service_port = atoi(optarg);
      break;
      case 'v':
	verbose = 1;
      break;
      case 'a':
	Random = 1;
	printf("Random data selection mode \n");
      break;
      case 'f':
      break;
      case 'h':
      default:
	Usage();
      break;
    }
  }

  result_open();
  onl_init(service_port, myID, "route.conf"); 

  ConfigApplication(APP_MGR, NULL, appmgr_plugin);
  ConfigApplication(APP_CASA, NULL, casa_app_plugin); 

  forever();

  return 0;
}

static void forever()
{
  extern pthread_t pth_receive_sock;

  pthread_join(pth_receive_sock, NULL);
  printf("out of client main\n");
}


static void result_open()
{
  extern int max;
  extern int min;
  char name[32];
  char foo[128];

  sprintf(name, "result_min_%d_max_%d_i_%d.txt", min, max, iter);

   /* system() must be used to get the results */
   sprintf(foo, "hostname > %s", name);
   system(foo);

  output = fopen(name, "a");
  fprintf(output, "\n");
  fprintf(output, "Iterration %d \n", iter);
   
}

