/* pson.c  */
/* Panho Lee */

#include "ccl.h"
#include "onl.h"
#include "cclqueue.h"
#include "timer.h"

int DEBUG = 0;
int verbose = 0;
int packet_size = 0;
int  myID;
static int service_port;
int  destination;
int run_mode;
int max;
int min;

static void create_tracer(int, int, int, char* );
Packet  * over_trace(Session *c, int dst, int ttl);

void Usage()
{
printf("\tovertrace [-t myid -d dst]\n");
printf("\t-h            print this message.\n");
printf("\t-v            verbose mode.\n");
printf("\t-t  <myid>   \n");
printf("\t-d  <dst>     destination(server) id.\n");

exit(1);
}

int main(int argc, char *argv[])
{
  extern char *optarg;
  int opt;

  while ((opt = getopt(argc, argv, "d:t:p:hv")) != EOF) {
    switch ((char)opt) {
      case 'd':
        destination = atoi(optarg);
      break;
      case 'p':
        service_port = atoi(optarg);
      break;
      case 't':
        myID = atoi(optarg);
      break;
      case 'v':
	verbose = 1;
      break;
      case 'f':
      break;
      case 'h':
      default:
	Usage();
      break;
    }
 }

 printf("my ID %d service port %d \n", myID, service_port);
 create_tracer(myID, destination, service_port, "route.conf"); 

  return 0;
}

static void create_tracer(int myid, int dst, int port, char* rib)
{
  extern void onl_init(int, int, char*);
  Session * session;
  Packet  * resp;
  int ttl = 1;

  /* Initialize Overlay Network Layer */
  onl_init(port, myid, rib);
  session = ccl_session_create(myid, port, 0, 0, T_NODE);

  printf("overtrace to %d \n", dst);
  while(1) {
    resp = over_trace(session, dst, ttl);
    printf("[%d] %d RTT = %f ms \n", ttl, resp->srcID, elapse_time(END, 0));
    if(resp->srcID == dst) 
      break;


    ttl++;
  }
}	

Packet  * over_trace(Session *c, int dst, int ttl)
{
  extern int onl_send(int, char*, int, int);

  CCLQNode * qnode;
  short    retry;
  static  char foo[128];
  
  CCLQueue* q = c->Q_connect;
  Packet *fr = (Packet *) foo;

  // Set the server node ID. 
  c->dstID = dst;

  /* connection request */
  fr->srcID = c->myID;
  fr->dstID = dst; 
  fr->opcode = OVER_TRC_REQ;
  fr->len = sizeof(OVTrace);
  fr->p.ovtrc.dstID = dst;
  fr->p.ovtrc.ttl = ttl;

  retry = 0;
  // send to overlay network layer
  onl_send(dst, (char *) fr, 128, 0);
  elapse_time(START, 0);

  // wait for acknowledgement 
  while (1) { 
    int rc = 0;
      /* wait for a message from socket receiver */
    pthread_mutex_lock(&q->mut);
    while(q->signal == 0) {  /* check for spurious wakeups */
      rc = pthread_cond_wait(&q->cond, &q->mut);         
    }
    q->signal = 0;

    while (q->size > 0) {
      qnode = ccl_dequeue(q);
      // ccl_destroy_node(qnode);
      fr = (Packet *) qnode->message;
      free(qnode);
      pthread_mutex_unlock(&q->mut);  /* release start lock (it can go back to fgets) */

      return(fr);
    }
    pthread_mutex_unlock(&q->mut);  /* release start lock (it can go back to fgets) */
  }
  return NULL; 
}

