/* timer.h, header for timer utility */
/* Panho Lee */
#ifndef API_TIMER
#define API_TIMER

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <pthread.h>
#include <unistd.h>

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#define START 0
#define END 1

void start_timer(int sec, int nsec, void (*ptr)());
void cancel_timer();
int timer_expired();
int check_timeout();
void release_timer_semaphore();
void create_time_ticker();
float elapse_time(int, int);

#endif
