/* packet.h */
/* Panho Lee */

#ifndef CC_QQS
#define CC_QQS

#define _REENTRANT

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

typedef struct pktnode
{
  struct pktnode* next;    /* point toward back of q */  
  char   * pkt; 
  int    len;              /* length of packet, including header */
  unsigned short bitpattern;  /* rate bit mask */
} PKTNode;

typedef struct pktqueue
{
  PKTNode* head;             /* head of queue */
  PKTNode* tail;             /* tail of queue */  
  int size;                /* size of queue */ 
} PKTQueue; 

PKTNode* init_packet_node(char *, int);
/* initialize packet queue for a client */
PKTQueue* init_packet_queue(PKTQueue*);

  /* add new packet to q */
void enqueue_packet(PKTQueue*, PKTNode*);

  /* remove packet from q */
PKTNode* dequeue_packet(PKTQueue*);

/*******************************************************************
 * Messege format
 *******************************************************************/
/* connection request */
#define CONN_REQ 1
typedef struct COReq {
    unsigned int targetRate; /* target rate in Mbps */
    unsigned int minimumRate;/* minimum rate in Mbps */
    unsigned int framingType;/* framing type (1 or 2) */
} COReq;

/* connection ack */
#define CONN_ACK 2
typedef struct COAck {
    unsigned int result; /* response fail(1), success (0) */
    unsigned int targetRate; /* target rate in Mbps */
    unsigned int minimumRate;/* minimum rate in Mbps */
    unsigned int framingType;/* framing type (1 or 2) */
} COAck;

#define DATA_PKT 4
typedef struct DATPkt {
    unsigned short sn;
    unsigned short plen;/* payload length */
    short int blkno;
    short int pktcnt;
    char     payload[4];
} DATPkt;

#define DATA_ACK 5
typedef struct DATAck {
    unsigned int currentRate;/* current rate in Mbps */
    unsigned int framingType;/* framing type (1 or 2) */
    unsigned int blkno;
    int          pcktcnt; /* the number of packet received at the client */
} DATAck;

#define OVER_TRC_REQ	100
#define OVER_TRC_RSP    101
#define OVER_TRC_LAT    102
typedef struct OVTrace {
  int  dstID;
  int  ttl;
  char ipaddr[16];
  int  nodeType;  /* node type (0 ~ 5) */
  int  port;
  int  t_sec;
  int  t_usec;
  int  blkno;
} OVTrace;
  
#define FRAME_HEADER_LEN  28
typedef struct PacketFormat {
    int dstID; /* destination node ID */
    int srcID; /* source node ID */
    unsigned char  opcode; /* opcode type */
    unsigned char  version;
    unsigned short len;   /* total length */
    unsigned short pdp;   /* packet drop priority */
    unsigned short current_rate;
    /* application specific optinal fields */
    union {
	COReq   coreq;
	COAck   coack;
	DATPkt  datpkt;
	DATAck  datack;
	OVTrace ovtrc; 
    } p;
} Packet;

#endif
