/* cmqueue.h */
/* header for client  message queues */
/* Panho Lee */

#ifndef CC_CLIENT_QQS
#define CC_CLIENT_QQS

#define _REENTRANT

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

#define BUF_SIZE 256
#define HEADER_SIZE 7

#define	NLP_USER_DATA		0
#define	NLP_RIB_UPDATE		(unsigned char ) (0x80|0x00)

typedef struct qnode 
{
  struct qnode* next;         /* point toward back of q */  
  char source[16];
  char destination[16];
  unsigned short srcPort;
  unsigned short dstPort;    /* checksum */
  unsigned short length;
  char *message;   
  int len;   
} QNode;

typedef struct mqueue
{
  pthread_mutex_t mut;     /* lock on the queue */
  pthread_cond_t cond;     /* notifier */
  int signal;              /* condition var */
  QNode* head;             /* head of queue */
  QNode* tail;             /* tail of queue */  
  int size;                /* size of queue */ 
  char name[32];           /* name of this Q */ 
} Queue; 

  /* print sockaddr fields of all nodes */
Queue* init_queue(Queue*, char*);

  /* a QNode* factory */
QNode* init_node(int , char*, char*, unsigned short, unsigned short, char*);

  /* add new message to q */
void enqueue(Queue*, QNode*);

  /* remove message from q */
QNode* dequeue(Queue*);

void destroy_queue(Queue*);
#endif
